using System;
using System.Data;
using System.Drawing.Imaging;
using System.IO;
using System.Web.UI.WebControls;
using DayPilot.Web.Ui.Events;
using DayPilot.Web.Ui.Events.Scheduler;


public partial class Timesheet : System.Web.UI.Page
{
    private DataTable table;

    protected void Page_Load(object sender, EventArgs e)
    {
        #region Data loading initialization
        if (Session["DaysModeMonth"] == null)
        {
            Session["DaysModeMonth"] = DataGeneratorScheduler.GetDataDays();
        }
        table = (DataTable)Session["DaysModeMonth"];
        DayPilotScheduler1.DataSource = Session["DaysModeMonth"];
        #endregion
        
        if (!IsPostBack)
        {
            DateTime start = new DateTime(DateTime.Today.Year, DateTime.Today.Month, 1);
            DateTime end = start.AddMonths(1);
            int days = (int)Math.Floor((end - start).TotalDays);

            DayPilotScheduler1.StartDate = start;
            DayPilotScheduler1.Days = days;

            DayPilotScheduler1.SetScrollX(DayPilotScheduler1.StartDate.Date.AddHours(8));

            DataBind();
        }

    }
    protected void DayPilotScheduler1_EventResize(object sender, DayPilot.Web.Ui.Events.EventResizeEventArgs e)
    {
        #region Simulation of database update

        DataRow dr = table.Rows.Find(e.Id);
        if (dr != null)
        {
            dr["start"] = e.NewStart;
            dr["end"] = e.NewEnd;
            table.AcceptChanges();
        }

        #endregion

        DayPilotScheduler1.DataBind();
        DayPilotScheduler1.Update();
    }
    protected void DayPilotScheduler1_EventMove(object sender, DayPilot.Web.Ui.Events.EventMoveEventArgs e)
    {
        #region Simulation of database update

        DataRow dr = table.Rows.Find(e.Id);
        if (dr != null)
        {
            dr["start"] = e.NewStart;
            dr["end"] = e.NewEnd;
            dr["column"] = e.NewResource;
            table.AcceptChanges();
        }

        #endregion

        DayPilotScheduler1.DataBind();
        DayPilotScheduler1.Update();

    }
    protected void DayPilotScheduler1_TimeRangeSelected(object sender, DayPilot.Web.Ui.Events.TimeRangeSelectedEventArgs e)
    {
        #region Simulation of database update

        DataRow dr = table.NewRow();
        dr["start"] = e.Start;
        dr["end"] = e.End;
        dr["id"] = Guid.NewGuid().ToString();
        dr["name"] = "New event";

        table.Rows.Add(dr);
        table.AcceptChanges();
        #endregion

        DayPilotScheduler1.DataBind();
        DayPilotScheduler1.Update();
    }
    
    protected void DayPilotScheduler1_BeforeTimeHeaderRender(object sender, DayPilot.Web.Ui.Events.BeforeTimeHeaderRenderEventArgs e)
    {
    }

    protected void DayPilotScheduler1_BeforeCellRender(object sender, BeforeCellRenderEventArgs e)
    {
        if (!e.IsBusiness)
        {
            e.BackgroundColor = "#e3e3e3";
        }
    }

    protected void DayPilotScheduler1_BeforeResHeaderRender(object sender, BeforeResHeaderRenderEventArgs e)
    {
        if (!DayPilotScheduler1.IsExport)
        {
            e.Html = String.Format("<div style='text-align:right; margin-right:5px;'>{0}</div>", e.Html);    
        }
    }

    protected void OnClick(object sender, EventArgs e)
    {
        

    }

    protected void ButtonExport_Click(object sender, EventArgs e)
    {

        DayPilotScheduler1.LoadStylesDefaultTheme();
        //DayPilotScheduler1.Width = Unit.Pixel(1000);  // use Unit.Percentage(100) for full width
        DayPilotScheduler1.StartDate = DayPilotScheduler1.ViewPort.Start;
        DayPilotScheduler1.Days = DayPilotScheduler1.ViewPort.Days;
        DayPilotScheduler1.Width = Unit.Percentage(100);

        DateTime start = new DateTime(DateTime.Today.Year, DateTime.Today.Month, 1);
        DateTime end = start.AddMonths(1);
        int days = (int)Math.Floor((end - start).TotalDays);

        DayPilotScheduler1.StartDate = start;
        DayPilotScheduler1.Days = days;

        DayPilotScheduler1.DataSource = Session["DaysModeMonth"];
        DayPilotScheduler1.DataBind();

        Response.Clear();
        Response.ContentType = "image/png";
        Response.AddHeader("content-disposition", "attachment;filename=print.png");
        DayPilotScheduler1.DataBind();
        MemoryStream img = DayPilotScheduler1.Export(ImageFormat.Png);
        img.WriteTo(Response.OutputStream);
        Response.End();
    }
}
