﻿Imports System
Imports System.Collections.Generic
Imports System.Data
Imports System.Text
Imports DayPilot.Web.Ui.Conflict
Imports DayPilot.Web.Ui.Data
Imports DayPilot.Web.Ui.Enums
Imports DayPilot.Web.Ui.Events
Imports DayPilot.Web.Ui.Events.Bubble
Imports DayPilot.Web.Ui.Events.Calendar

Partial Public Class Calendar_ActiveAreas
	Inherits System.Web.UI.Page

	Private table As DataTable

	Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
'		#Region "Data loading initialization"
		If Session("AllFeatures") Is Nothing Then
			Session("AllFeatures") = DataGeneratorCalendar.GetData()
		End If
		table = DirectCast(Session("AllFeatures"), DataTable)
		DayPilotCalendar1.DataSource = Session("AllFeatures")
		DayPilotNavigator1.DataSource = Session("AllFeatures")
'		#End Region



		If Not IsPostBack Then
			DataBind()
			DayPilotCalendar1.UpdateWithMessage("Welcome!")

		End If
	End Sub

	Protected Sub DayPilotCalendar1_EventMove(ByVal sender As Object, ByVal e As EventMoveEventArgs)

'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			table.AcceptChanges()
		End If

'		#End Region

		DayPilotCalendar1.DataBind()
		DayPilotCalendar1.UpdateWithMessage("Event moved.")
		DayPilotCalendar1.Update()

	End Sub

	Protected Sub DayPilotCalendar1_EventMenuClick(ByVal sender As Object, ByVal e As EventMenuClickEventArgs)
		If e.Command = "Delete" Then
'			#Region "Simulation of database update"
			Dim dr As DataRow = table.Rows.Find(e.Id)

			If dr IsNot Nothing Then
				table.Rows.Remove(dr)
				table.AcceptChanges()
			End If
'			#End Region

			DayPilotCalendar1.DataBind()
			DayPilotCalendar1.Update()
		End If
	End Sub
	Protected Sub DayPilotCalendar1_TimeRangeSelected(ByVal sender As Object, ByVal e As TimeRangeSelectedEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.NewRow()
		dr("start") = e.Start
		dr("end") = e.End
		dr("id") = Guid.NewGuid().ToString()
		dr("name") = "New event"

		table.Rows.Add(dr)
		table.AcceptChanges()
'		#End Region

		DayPilotCalendar1.DataBind()
		DayPilotCalendar1.UpdateWithMessage("New event created.")
	End Sub

	Protected Sub DayPilotCalendar1_EventResize(ByVal sender As Object, ByVal e As EventResizeEventArgs)
		' not allowed to resize event no 7
		If e.Id = "7" Then
			DayPilotCalendar1.DataBind()
			DayPilotCalendar1.UpdateWithMessage("It's not allowed to resize this event. It was forbidded in the EventResize handler on the server side.")
			Return
		End If

'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			table.AcceptChanges()
		End If

'		#End Region

		DayPilotCalendar1.DataBind()
		DayPilotCalendar1.UpdateWithMessage("Event resized")
	End Sub

	Protected Sub DayPilotCalendar1_EventClick(ByVal sender As Object, ByVal e As EventClickEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("name") = "Event clicked at " & Date.Now
			table.AcceptChanges()
		End If

'		#End Region

		DayPilotCalendar1.DataBind()
		DayPilotCalendar1.Update()
	End Sub
	Protected Sub DayPilotCalendar1_EventEdit(ByVal sender As Object, ByVal e As EventEditEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("name") = e.NewText
			table.AcceptChanges()
		End If

'		#End Region

		DayPilotCalendar1.DataBind()
		DayPilotCalendar1.UpdateWithMessage("Event text changed.")
	End Sub
	Protected Sub DayPilotCalendar1_BeforeEventRender(ByVal sender As Object, ByVal e As BeforeEventRenderEventArgs)
		e.CssClass = "calendar_white_event_withheader"

		e.Areas.Add((New Area()).Right(3).Top(3).Width(15).Height(15).CssClass("event_action_delete").JavaScript("dpc1.eventDeleteCallBack(e);"))
		e.Areas.Add((New Area()).Right(20).Top(3).Width(15).Height(15).CssClass("event_action_menu").JavaScript("dpc1.bubble.showEvent(e, true);"))
		e.Areas.Add((New Area()).Left(0).Bottom(5).Right(0).Height(5).CssClass("event_action_bottomdrag").ResizeEnd())
		e.Areas.Add((New Area()).Left(15).Top(1).Right(46).Height(11).CssClass("event_action_move").Move())
	End Sub


	Protected Sub DayPilotCalendar1_EventDelete(ByVal sender As Object, ByVal e As EventDeleteEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			table.Rows.Remove(dr)
			table.AcceptChanges()
		End If

'		#End Region

		DayPilotCalendar1.DataBind()
		DayPilotCalendar1.UpdateWithMessage("Event deleted.")
	End Sub

	Protected Sub DayPilotCalendar1_EventSelect(ByVal sender As Object, ByVal e As DayPilotEventArgs)
		DayPilotCalendar1.Update()
	End Sub

	Protected Sub DayPilotCalendar1_BeforeHeaderRender(ByVal sender As Object, ByVal e As BeforeHeaderRenderEventArgs)
		e.Areas.Add((New Area()).Right(1).Top(0).Width(17).Bottom(1).CssClass("resource_action_menu").Html("<div><div></div></div>").JavaScript("alert(e.date);"))
	End Sub

	Protected Sub DayPilotBubble1_RenderContent(ByVal sender As Object, ByVal e As RenderEventArgs)
		If TypeOf e Is RenderEventBubbleEventArgs Then
			Dim re As RenderEventBubbleEventArgs = TryCast(e, RenderEventBubbleEventArgs)

			Dim sb As New StringBuilder()
			sb.AppendFormat("<b>{0}</b><br />", re.Text)
			sb.AppendFormat("Start: {0}<br />", re.Start)
			sb.AppendFormat("End: {0}<br />", re.End)

			're.InnerHTML = "<b>Event details</b><br />Here is the right place to show details about the event with ID: " + re.Value + ". This text is loaded dynamically from the server.<br/>";
			re.InnerHTML = sb.ToString()
		ElseIf TypeOf e Is RenderTimeBubbleEventArgs Then
			Dim re As RenderTimeBubbleEventArgs = TryCast(e, RenderTimeBubbleEventArgs)
			e.InnerHTML = "<b>Time header details</b><br />From:" & re.Start & "<br />To: " & re.End
		ElseIf TypeOf e Is RenderCellBubbleEventArgs Then
			Dim re As RenderCellBubbleEventArgs = TryCast(e, RenderCellBubbleEventArgs)
			e.InnerHTML = "<b>Cell details</b><br />Column:" & re.ResourceId & "<br />From:" & re.Start & "<br />To: " & re.End
		End If
	End Sub

	Protected Sub DayPilotCalendar1_TimeRangeDoubleClick(ByVal sender As Object, ByVal e As TimeRangeDoubleClickEventArgs)

'		#Region "Simulation of database update"
		Dim dr As DataRow = table.NewRow()
		dr("start") = e.Start
		dr("end") = e.End
		dr("id") = Guid.NewGuid().ToString()
		dr("name") = "New event"

		table.Rows.Add(dr)
		table.AcceptChanges()
'		#End Region

		DayPilotCalendar1.DataBind()
		DayPilotCalendar1.UpdateWithMessage("New event created.")
	End Sub

	Protected Sub DayPilotCalendar1_TimeRangeMenuClick(ByVal sender As Object, ByVal e As TimeRangeMenuClickEventArgs)
		If e.Command = "Insert" Then
'			#Region "Simulation of database update"

			Dim dr As DataRow = table.NewRow()
			dr("start") = e.Start
			dr("end") = e.End
			dr("id") = Guid.NewGuid().ToString()
			dr("name") = "New event"

			table.Rows.Add(dr)
			table.AcceptChanges()
'			#End Region

			DayPilotCalendar1.DataBind()
			DayPilotCalendar1.Update()
		End If

	End Sub
	Protected Sub DayPilotCalendar1_Command(ByVal sender As Object, ByVal e As CommandEventArgs)
		Select Case e.Command
			Case "navigate"
				Dim start As Date = CDate(e.Data("start"))
				Dim [end] As Date = CDate(e.Data("end"))

				DayPilotCalendar1.StartDate = start
				DayPilotCalendar1.DataBind()
				DayPilotCalendar1.Update()
			Case "refresh"
				DayPilotCalendar1.DataBind()
				DayPilotCalendar1.UpdateWithMessage("Refreshed.")
			Case "paste"
				Dim pasteHere As Date = CDate(e.Data("start"))
'NOTE: The variable id was renamed since Visual Basic does not handle local variables named the same as class members well:
				Dim id_Renamed As String = CStr(e.Data("id"))

				Dim dr As DataRow = table.Rows.Find(id_Renamed)
				If dr IsNot Nothing Then
					Dim duration As TimeSpan = (DirectCast(dr("end"), Date)) - (DirectCast(dr("start"), Date))

					Dim drNew As DataRow = table.NewRow()
					drNew("start") = pasteHere
					drNew("end") = pasteHere.Add(duration)
					drNew("id") = Guid.NewGuid().ToString()
					drNew("name") = "Copy of " & dr("name")

					table.Rows.Add(drNew)
					table.AcceptChanges()
				End If
				DayPilotCalendar1.DataBind()
				DayPilotCalendar1.UpdateWithMessage("Event copied.")
			Case "test"
				Dim val As String = CStr(DayPilotCalendar1.ClientState("test"))
				DayPilotCalendar1.DataBind()
				DayPilotCalendar1.UpdateWithMessage("ClientState['test'] = " & val)

		End Select
	End Sub

	Protected Sub DayPilotNavigator1_VisibleRangeChanged(ByVal sender As Object, ByVal e As EventArgs)
		DayPilotNavigator1.DataBind()
	End Sub

	Protected Sub DayPilotCalendar1_BeforeCellRender(ByVal sender As Object, ByVal e As BeforeCellRenderEventArgs)
	End Sub

	Protected Sub DayPilotCalendar1_HeaderClick(ByVal sender As Object, ByVal e As HeaderClickEventArgs)
	End Sub
	Protected Sub DayPilotNavigator1_TimeRangeSelected(ByVal sender As Object, ByVal e As TimeRangeSelectedEventArgs)
		Throw New Exception(e.Start.ToString())
	End Sub
	Protected Sub DayPilotCalendar1_BeforeTimeHeaderRender(ByVal ea As DayPilot.Web.Ui.Events.Calendar.BeforeTimeHeaderRenderEventArgs)
		ea.Areas.Add((New Area()).Width(15).Top(0).Bottom(0).Right(0).CssClass("resource_action_menu").Html("<div><div></div></div>").JavaScript("alert(e.start);"))
	End Sub

	Protected Sub DayPilotNavigator1_BeforeCellRender(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.Navigator.BeforeCellRenderEventArgs)
	End Sub

	Protected Sub DayPilotBubble1_OnRenderCellBubble(ByVal sender As Object, ByVal e As RenderCellBubbleEventArgs)
		e.InnerHTML = "Information for cell starting at " & e.Start
	End Sub

End Class
