﻿Imports System
Imports System.Data
Imports DayPilot.Web.Ui.Events
Imports DayPilot.Web.Ui.Events.Calendar

Partial Public Class ContextMenu
	Inherits System.Web.UI.Page

	Private table As DataTable
	Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
'		#Region "Data loading initialization"
		If Session("ContextMenuData") Is Nothing Then
			Session("ContextMenuData") = DataGeneratorCalendar.GetData()
		End If
		table = DirectCast(Session("ContextMenuData"), DataTable)
		DayPilotCalendar1.DataSource = Session("ContextMenuData")
'		#End Region

		If Not IsPostBack Then
			DataBind()
		End If

	End Sub


	Protected Sub DayPilotCalendar1_EventMenuClick(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.EventMenuClickEventArgs)
		If e.Command = "Delete" Then
'			#Region "Simulation of database update"
			Dim dr As DataRow = table.Rows.Find(e.Id)
			If dr IsNot Nothing Then
				table.Rows.Remove(dr)
				table.AcceptChanges()
			End If
'			#End Region

			DayPilotCalendar1.DataBind()
			DayPilotCalendar1.Update()
		End If

	End Sub
	Protected Sub DayPilotCalendar1_BeforeEventRender(ByVal sender As Object, ByVal e As BeforeEventRenderEventArgs)
		If e.Id = "4" Then
			e.Html = "This event has a special context menu"
			e.DurationBarColor = "red"
			e.ContextMenuClientName = "specialmenu"
		End If
	End Sub


End Class
