﻿Imports System
Imports System.Data
Imports System.Web.UI
Imports DayPilot.Utils
Imports DayPilot.Web.Ui
Imports DayPilot.Web.Ui.Enums
Imports DayPilot.Web.Ui.Events
Imports DayPilot.Web.Ui.Events.Bubble

Partial Public Class DaysResourcesView
	Inherits Page

	Private table As DataTable

	Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
'		#Region "Data loading initialization"
		If Session("ResourcesMultiDayView") Is Nothing Then
			Session("ResourcesMultiDayView") = DataGeneratorCalendar.GetData()
		End If
		table = DirectCast(Session("ResourcesMultiDayView"), DataTable)
		DayPilotCalendar1.DataSource = Session("ResourcesMultiDayView")
'		#End Region

		defineColumns()

		If Not IsPostBack Then
			DataBind()
		End If
	End Sub

	Private Sub defineColumns()
		DayPilotCalendar1.Columns.Clear()

		Dim first As Date = Week.FirstDayOfWeek(DayPilotCalendar1.StartDate)

		For i As Integer = 0 To 6
			Dim day As Date = first.AddDays(i)

			Dim c As New Column(day.ToShortDateString(), day.ToString("s"))
			c.Date = day
			DayPilotCalendar1.Columns.Add(c)

			Dim c1 As New Column("A", "A")
			c1.Date = day
			c.Children.Add(c1)

			Dim c2 As New Column("B", "B")
			c2.Date = day
			c.Children.Add(c2)

			If day.Date = Date.Today Then
				Dim c3 As New Column("C", "C")
				c3.Date = day
				c.Children.Add(c3)
			End If

		Next i
	End Sub


	Protected Sub DayPilotCalendar1_TimeRangeSelected(ByVal sender As Object, ByVal e As TimeRangeSelectedEventArgs)
		DayPilotCalendar1.Update()
	End Sub

	Protected Sub DayPilotCalendar1_EventResize(ByVal sender As Object, ByVal e As EventResizeEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			table.AcceptChanges()

		End If

'		#End Region

		DayPilotCalendar1.DataBind()
		DayPilotCalendar1.Update()

	End Sub
	Protected Sub DayPilotCalendar1_EventMove(ByVal sender As Object, ByVal e As EventMoveEventArgs)

'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			dr("column") = e.NewResource
			table.AcceptChanges()
		End If

'		#End Region

		DayPilotCalendar1.DataBind()
		DayPilotCalendar1.Update()
	End Sub

	Protected Sub DayPilotBubble1_RenderContent(ByVal sender As Object, ByVal e As RenderEventArgs)
		If TypeOf e Is RenderResourceBubbleEventArgs Then
			Dim re As RenderResourceBubbleEventArgs = TryCast(e, RenderResourceBubbleEventArgs)
			e.InnerHTML = "<b>Resource header details</b><br />Value: " & re.ResourceId
		End If
	End Sub

	Protected Sub DayPilotCalendar1_Refresh(ByVal sender As Object, ByVal e As RefreshEventArgs)
		DayPilotCalendar1.StartDate = e.StartDate
		defineColumns() ' required, the StartDate was changes
		DayPilotCalendar1.DataBind()
		DayPilotCalendar1.Update(CallBackUpdateType.Full)
	End Sub
	Protected Sub DayPilotCalendar1_Command(ByVal sender As Object, ByVal e As CommandEventArgs)
		Select Case e.Command
			Case "previous"
				DayPilotCalendar1.StartDate = DayPilotCalendar1.StartDate.AddDays(-7)
			Case "next"
				DayPilotCalendar1.StartDate = DayPilotCalendar1.StartDate.AddDays(7)
			Case "today"
				DayPilotCalendar1.StartDate = Week.FirstDayOfWeek()
		End Select

		defineColumns() ' required, the StartDate was changes
		DayPilotCalendar1.DataBind()
		DayPilotCalendar1.Update(CallBackUpdateType.Full)

	End Sub
End Class
