﻿' Copyright � 2005 - 2011 Annpoint, s.r.o.
'   Use of this software is subject to license terms. 
'   http://www.daypilot.org/
'
'   If you have purchased a DayPilot Pro license, you are allowed to use this 
'   code under the conditions of DayPilot Pro License Agreement:
'
'   http://www.daypilot.org/files/LicenseAgreement.pdf
'
'   Otherwise, you are allowed to use it for evaluation purposes only under 
'   the conditions of DayPilot Pro Trial License Agreement:
'   
'   http://www.daypilot.org/files/LicenseAgreementTrial.pdf
'   
'

Imports System
Imports System.Data
Imports System.Web.UI

Partial Public Class Edit
	Inherits Page

	Private table As DataTable

	Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
		If Not IsPostBack Then

			Dim ev As DataRow = loadEvent(Request.QueryString("id"))

			TextBoxStart.Text = Convert.ToDateTime(ev("start")).ToString()
			TextBoxEnd.Text = Convert.ToDateTime(ev("end")).ToString()
			TextBoxName.Text = Convert.ToString(ev("name"))

			'TextBoxName.Focus();
		End If
	End Sub
	Protected Sub ButtonOK_Click(ByVal sender As Object, ByVal e As EventArgs)
		Dim start As Date = Convert.ToDateTime(TextBoxStart.Text)
		Dim [end] As Date = Convert.ToDateTime(TextBoxEnd.Text)
		Dim name As String = TextBoxName.Text

		dbUpdateEvent(Request.QueryString("id"), start, [end], name, Nothing)
		Modal.Close(Me, "OK")
	End Sub

	Private Function dbUpdateEvent(ByVal id As String, ByVal start As Date, ByVal [end] As Date, ByVal name As String, ByVal resource As String) As String
		initData()

'		#Region "Simulation of database update"

		Dim dr As DataRow = loadEvent(id)
		dr("start") = start
		dr("end") = [end]
		dr("id") = id
		dr("name") = name
		dr("column") = resource

		'table.Rows.Add(dr);
		table.AcceptChanges()
'		#End Region

		Return id
	End Function

	Protected Sub ButtonCancel_Click(ByVal sender As Object, ByVal e As EventArgs)
		Modal.Close(Me)
	End Sub

	Private Sub initData()
'NOTE: The variable id was renamed since Visual Basic does not handle local variables named the same as class members well:
		Dim id_Renamed As String = "AllFeatures"

		If Session(id_Renamed) Is Nothing Then
			Session(id_Renamed) = DataGeneratorCalendar.GetData()
		End If
		table = DirectCast(Session(id_Renamed), DataTable)
	End Sub

	Private Function loadEvent(ByVal id As String) As DataRow
		initData()

		Return table.Rows.Find(id)

	End Function

End Class
