﻿Imports System
Imports System.Data
Imports DayPilot.Web.Ui.Events

Partial Public Class EventCreating
	Inherits System.Web.UI.Page

	Private table As DataTable

	Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
'		#Region "Data loading initialization"
		If Session("TimeRangeData") Is Nothing Then
			Session("TimeRangeData") = DataGeneratorCalendar.GetData()
		End If
		table = DirectCast(Session("TimeRangeData"), DataTable)
		DayPilotCalendar1.DataSource = Session("TimeRangeData")
'		#End Region

		If Not IsPostBack Then
			DayPilotCalendar1.StartDate = DayPilot.Utils.Week.FirstDayOfWeek(Date.Today)
			DataBind()
		End If
	End Sub


	Protected Sub DayPilotCalendar1_TimeRangeSelected(ByVal sender As Object, ByVal e As TimeRangeSelectedEventArgs)
'		#Region "Simulation of database update"
		Dim dr As DataRow = table.NewRow()
		dr("start") = e.Start
		dr("end") = e.End
		dr("id") = Guid.NewGuid().ToString()
		dr("name") = "New event"

		table.Rows.Add(dr)
		table.AcceptChanges()
'		#End Region

		DayPilotCalendar1.DataBind()
		DayPilotCalendar1.Update()
	End Sub

	Protected Sub DayPilotCalendar1_TimeRangeMenuClick(ByVal sender As Object, ByVal e As TimeRangeMenuClickEventArgs)
		If e.Command = "Insert" Then
'			#Region "Simulation of database update"
			Dim dr As DataRow = table.NewRow()
			dr("start") = e.Start
			dr("end") = e.End
			dr("id") = Guid.NewGuid().ToString()
			dr("name") = "New event"

			table.Rows.Add(dr)
			table.AcceptChanges()
'			#End Region

			DayPilotCalendar1.DataBind()
			DayPilotCalendar1.Update()

		End If
	End Sub
End Class
