﻿Imports System
Imports System.Data
Imports DayPilot.Web.Ui.Events.Calendar


Partial Public Class EventDeleting
	Inherits System.Web.UI.Page

	Private table As DataTable

	Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
'		#Region "Data loading initialization"
		If Session("EventDeleting") Is Nothing Then
			Session("EventDeleting") = DataGeneratorCalendar.GetData()
		End If
		table = DirectCast(Session("EventDeleting"), DataTable)
		DayPilotCalendar1.DataSource = Session("EventDeleting")
'		#End Region


		If Not IsPostBack Then
			DayPilotCalendar1.StartDate = DayPilot.Utils.Week.FirstDayOfWeek(Date.Today)
			DataBind()
		End If

	End Sub
	Protected Sub DayPilotCalendar1_EventDelete(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.Calendar.EventDeleteEventArgs)
		deleteAndBind(e.Id)
	End Sub

	Private Sub deleteAndBind(ByVal id As String)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(id)
		If dr IsNot Nothing Then
			table.Rows.Remove(dr)
			table.AcceptChanges()
		End If

'		#End Region

		DayPilotCalendar1.DataBind()
		DayPilotCalendar1.Update()

	End Sub

	Protected Sub DayPilotCalendar1_OnBeforeEventRender(ByVal sender As Object, ByVal e As BeforeEventRenderEventArgs)
	End Sub
End Class
