﻿Imports System
Imports System.Data
Imports DayPilot.Web.Ui.Events

Partial Public Class Editing
	Inherits System.Web.UI.Page

	Private table As DataTable

	Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
'		#Region "Data loading initialization"
		If Session("EventDeleting") Is Nothing Then
			Session("EventDeleting") = DataGeneratorCalendar.GetData()
		End If
		table = DirectCast(Session("EventDeleting"), DataTable)
		DayPilotCalendar1.DataSource = Session("EventDeleting")
'		#End Region

		If Not IsPostBack Then
			DayPilotCalendar1.StartDate = DayPilot.Utils.Week.FirstDayOfWeek(Date.Today)
			DataBind()
		End If
	End Sub

	Protected Sub DayPilotCalendar1_EventEdit(ByVal sender As Object, ByVal e As EventEditEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)

		If dr IsNot Nothing Then
			dr("name") = e.NewText
			table.AcceptChanges()
		End If

'		#End Region

		DayPilotCalendar1.DataBind()
		DayPilotCalendar1.Update()
	End Sub
End Class
