﻿Imports System
Imports System.Data

Partial Public Class Moving
	Inherits System.Web.UI.Page

	Private table As DataTable

	Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
'		#Region "Data loading initialization"
		If Session("EventMoving") Is Nothing Then
			Session("EventMoving") = DataGeneratorCalendar.GetData()
		End If
		table = DirectCast(Session("EventMoving"), DataTable)
		DayPilotCalendar1.DataSource = Session("EventMoving")
'		#End Region

		If Not IsPostBack Then
			DayPilotCalendar1.StartDate = DayPilot.Utils.Week.FirstDayOfWeek(Date.Today)
			DataBind()
		End If
	End Sub


	Protected Sub DayPilotCalendar1_EventMove(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.EventMoveEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			table.AcceptChanges()
		End If

'		#End Region

		DayPilotCalendar1.DataBind()
		DayPilotCalendar1.Update()
	End Sub
End Class
