﻿Imports System
Imports System.Data
Imports DayPilot.Web.Ui.Events
Imports DayPilot.Web.Ui.Events.Common

Partial Public Class EventSelecting
	Inherits System.Web.UI.Page

	Private table As DataTable

	Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
'		#Region "Data loading initialization"
		If Session("EventSelecting") Is Nothing Then
			Session("EventSelecting") = DataGeneratorCalendar.GetData()
		End If
		table = DirectCast(Session("EventSelecting"), DataTable)
		DayPilotCalendar1.DataSource = Session("EventSelecting")
'		#End Region


		If Not IsPostBack Then
			DayPilotCalendar1.StartDate = DayPilot.Utils.Week.FirstDayOfWeek(Date.Today)
			DataBind()
		End If
	End Sub


	Protected Sub DayPilotCalendar1_TimeRangeSelected(ByVal sender As Object, ByVal e As TimeRangeSelectedEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.NewRow()
		dr("start") = e.Start
		dr("end") = e.End
		dr("id") = Guid.NewGuid().ToString()
		dr("name") = "New event"

		table.Rows.Add(dr)
		table.AcceptChanges()
'		#End Region

		DayPilotCalendar1.DataBind()
		DayPilotCalendar1.Update()
	End Sub

	Protected Sub DayPilotCalendar1_EventSelect(ByVal sender As Object, ByVal e As DayPilotEventArgs)
		DayPilotCalendar1.DataBind()
		DayPilotCalendar1.Update()
	End Sub

	Protected Sub DayPilotCalendar1_EventMove(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.EventMoveEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			table.AcceptChanges()
		End If


'		#End Region

		DayPilotCalendar1.DataBind()
		DayPilotCalendar1.Update()
	End Sub
	Protected Sub DayPilotCalendar1_Command(ByVal sender As Object, ByVal e As CommandEventArgs)
		If DayPilotCalendar1.SelectedEvents.Count > 0 Then
			Dim ei As EventInfo = DayPilotCalendar1.SelectedEvents(0)
			DayPilotCalendar1.SelectedEvents.RemoveAt(0)
			DayPilotCalendar1.DataBind()
			DayPilotCalendar1.UpdateWithMessage("Event removed from selection: " & ei.Text)
		End If


'        
'        foreach(EventInfo ei in DayPilotCalendar1.SelectedEvents)
'        {
'            list += ei.Value + ":";
'        }
'         * 



		'throw new Exception(list);
	End Sub
End Class
