﻿Imports System
Imports System.Data
Imports System.Configuration
Imports System.Collections
Imports System.Drawing.Imaging
Imports System.IO
Imports System.Web
Imports System.Web.Security
Imports System.Web.UI
Imports System.Web.UI.WebControls
Imports System.Web.UI.WebControls.WebParts
Imports System.Web.UI.HtmlControls
Imports DayPilot.Web.Ui
Imports DayPilot.Web.Ui.Enums
Imports DayPilot.Web.Ui.Enums.Calendar
Imports DayPilot.Web.Ui.Events
Imports DayPilot.Web.Ui.Events.Calendar

Partial Public Class Calendar_Export
	Inherits System.Web.UI.Page

	Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
		defineColumns()

		DayPilotCalendar1.StartDate = DayPilot.Utils.Week.FirstDayOfWeek()

		If Session("AllFeatures") Is Nothing Then
			Session("AllFeatures") = DataGeneratorCalendar.GetData()
		End If




		DayPilotCalendar1.DataSource = Session("AllFeatures")
		DataBind()

		' override the output
		Response.Clear()
		Response.ContentType = "image/png"
		Dim img As MemoryStream = DayPilotCalendar1.Export(ImageFormat.Png)
		img.WriteTo(Response.OutputStream)
		Response.End()
	End Sub

	Private Sub defineColumns()
		DayPilotCalendar1.Columns.Clear()

		Dim first As Date = DayPilotCalendar1.StartDate

		Dim resources() As String = { "A", "B", "C" }

		For i As Integer = 0 To 2

			Dim c As New Column(resources(i), resources(i))
			DayPilotCalendar1.Columns.Add(c)

			For j As Integer = 0 To 1
				Dim day As Date = first.AddDays(j)

				Dim subC As New Column(day.ToShortDateString(), resources(i))
				subC.Date = day
				c.Children.Add(subC)
			Next j
		Next i
	End Sub


	Protected Sub DayPilotCalendar1_BeforeEventRender(ByVal sender As Object, ByVal e As BeforeEventRenderEventArgs)
		If e.Id = "3" Then
			'e.InnerHTML = "User actions (\"move\", \"resize\", \"click\", and 'delete') disabled for this specific event.";
			'e.InnerHTML = "User actions (move, resize, click, and delete) disabled for this specific event.";
			e.Html = "User actions"
			e.DurationBarColor = "red"
			e.EventClickEnabled = False
			e.EventMoveEnabled = False
			e.EventResizeEnabled = False
			e.EventDeleteEnabled = False
			e.ToolTip = "One" & vbLf & "two" & vbLf & "three."
		End If

		If e.Id = "7" Then
			e.DurationBarImageUrl = "../Media/linked/tentative5x8.gif"
		End If
	End Sub

	Protected Sub DayPilotCalendar1_BeforeHeaderRender(ByVal sender As Object, ByVal e As BeforeHeaderRenderEventArgs)
		If DayPilotCalendar1.ViewType = ViewTypeEnum.Days Then
			e.Html = e.Date.ToString("d MMMM yyyy")
		End If
	End Sub


End Class
