﻿Imports System
Imports System.Data
Imports System.Configuration
Imports System.Collections
Imports System.Web
Imports System.Web.Security
Imports System.Web.UI
Imports System.Web.UI.WebControls
Imports System.Web.UI.WebControls.WebParts
Imports System.Web.UI.HtmlControls

Partial Public Class Calendar_ExternalDragDrop
	Inherits System.Web.UI.Page

	Private table As DataTable

	Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
'		#Region "Data loading initialization"
		If Session("ExternalDragDrop") Is Nothing Then
			Session("ExternalDragDrop") = DataGeneratorCalendar.GetData()
		End If
		table = DirectCast(Session("ExternalDragDrop"), DataTable)
		DayPilotCalendar1.DataSource = Session("ExternalDragDrop")
'		#End Region


		If Not IsPostBack Then
			DayPilotCalendar1.StartDate = DayPilot.Utils.Week.FirstDayOfWeek(Date.Today)
			DataBind()
		End If
	End Sub
	Protected Sub DayPilotCalendar1_EventMove(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.EventMoveEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			table.AcceptChanges()
		Else
			dr = table.NewRow()
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			dr("id") = e.Id
			dr("name") = e.Text

			table.Rows.Add(dr)
			table.AcceptChanges()
		End If


'		#End Region

		DayPilotCalendar1.DataBind()
		DayPilotCalendar1.Update()
	End Sub
End Class
