﻿Imports System
Imports System.Collections
Imports System.Data
Imports System.Drawing.Imaging
Imports System.IO
Imports System.Text
Imports System.Threading
Imports DayPilot.Web.Ui.Enums
Imports DayPilot.Web.Ui.Events
Imports DayPilot.Web.Ui.Events.Bubble
Imports DayPilot.Web.Ui.Events.Calendar

Partial Public Class Calendar_ImageExport
	Inherits System.Web.UI.Page

	Private table As DataTable
	'private DateTime greenStart;

	Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
'		#Region "Data loading initialization"
		If Session("AllFeatures") Is Nothing Then
			Session("AllFeatures") = DataGeneratorCalendar.GetData()
		End If
		table = DirectCast(Session("AllFeatures"), DataTable)
		DayPilotCalendar1.DataSource = Session("AllFeatures")
		DayPilotNavigator1.DataSource = Session("AllFeatures")
'		#End Region

		If Not IsPostBack Then
			DayPilotCalendar1.StartDate = DayPilot.Utils.Week.FirstDayOfWeek()
			DataBind()
		End If
	End Sub

	Protected Sub DayPilotCalendar1_EventMove(ByVal sender As Object, ByVal e As EventMoveEventArgs)

'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			table.AcceptChanges()
		End If

'		#End Region

		DayPilotCalendar1.DataBind()

		Dim ht As New Hashtable()
		ht("message") = "Event moved."
		ht("id") = e.Id

		DayPilotCalendar1.Update(ht)
	End Sub

	Protected Sub DayPilotCalendar1_EventMenuClick(ByVal sender As Object, ByVal e As EventMenuClickEventArgs)
		If e.Command = "Delete" Then
'			#Region "Simulation of database update"
			Dim dr As DataRow = table.Rows.Find(e.Id)

			If dr IsNot Nothing Then
				table.Rows.Remove(dr)
				table.AcceptChanges()
			End If
'			#End Region

			DayPilotCalendar1.DataBind()
			DayPilotCalendar1.Update()
		End If
	End Sub
	Protected Sub DayPilotCalendar1_TimeRangeSelected(ByVal sender As Object, ByVal e As TimeRangeSelectedEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.NewRow()
		dr("start") = e.Start
		dr("end") = e.End
		dr("id") = Guid.NewGuid().ToString()
		dr("name") = "New event"

		table.Rows.Add(dr)
		table.AcceptChanges()
'		#End Region

		DayPilotCalendar1.DataBind()
		DayPilotCalendar1.Update("New event created.")
	End Sub

	Protected Sub DayPilotCalendar1_EventResize(ByVal sender As Object, ByVal e As EventResizeEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			table.AcceptChanges()
		End If

'		#End Region

		DayPilotCalendar1.DataBind()
		DayPilotCalendar1.Update("Event resized")
	End Sub

	Protected Sub DayPilotCalendar1_EventClick(ByVal sender As Object, ByVal e As EventClickEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("name") = "Event clicked at " & Date.Now
			table.AcceptChanges()
		End If

'		#End Region

		DayPilotCalendar1.DataBind()
		DayPilotCalendar1.Update()
	End Sub
	Protected Sub DayPilotCalendar1_EventEdit(ByVal sender As Object, ByVal e As EventEditEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("name") = e.NewText
			table.AcceptChanges()
		End If

'		#End Region

		DayPilotCalendar1.DataBind()
		DayPilotCalendar1.Update("Event text changed.")
	End Sub
	Protected Sub DayPilotCalendar1_BeforeEventRender(ByVal sender As Object, ByVal e As BeforeEventRenderEventArgs)
		If e.Id = "3" Then
			'e.InnerHTML = "User actions (\"move\", \"resize\", \"click\", and 'delete') disabled for this specific event.";
			e.Html = "User actions (move, resize, click, and delete) disabled for this event."
			'e.InnerHTML = "User actions";
			e.DurationBarColor = "red"
			e.EventClickEnabled = False
			e.EventMoveEnabled = False
			e.EventResizeEnabled = False
			e.EventDeleteEnabled = False
			e.ToolTip = "One" & vbLf & "two" & vbLf & "three."
			'e.ContextMenuClientName = DayPilotMenu1.ClientObjectName;

			e.BubbleHtml = "Static ToolTip"
		End If

		If e.Id = "7" Then
			e.DurationBarImageUrl = "../Media/linked/tentative5x8.gif"
		End If

	End Sub


	Protected Sub DayPilotCalendar1_EventDelete(ByVal sender As Object, ByVal e As EventDeleteEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			table.Rows.Remove(dr)
			table.AcceptChanges()
		End If

'		#End Region

		DayPilotCalendar1.DataBind()
		DayPilotCalendar1.Update("Event deleted.")
	End Sub

	Protected Sub DayPilotCalendar1_EventSelect(ByVal sender As Object, ByVal e As DayPilotEventArgs)
		DayPilotCalendar1.Update()
	End Sub

	Protected Sub DayPilotCalendar1_Refresh(ByVal sender As Object, ByVal e As RefreshEventArgs)
		DayPilotCalendar1.StartDate = DayPilot.Utils.Week.FirstDayOfWeek(e.StartDate)
		DayPilotCalendar1.DataBind()
		DayPilotCalendar1.Update(CallBackUpdateType.Full)
	End Sub


	Protected Sub DayPilotCalendar1_BeforeHeaderRender(ByVal sender As Object, ByVal e As BeforeHeaderRenderEventArgs)
	End Sub

	Protected Sub DayPilotBubble1_RenderContent(ByVal sender As Object, ByVal e As RenderEventArgs)
		If TypeOf e Is RenderEventBubbleEventArgs Then
			Dim re As RenderEventBubbleEventArgs = TryCast(e, RenderEventBubbleEventArgs)

			Dim sb As New StringBuilder()
			sb.AppendFormat("<b>{0}</b><br />", re.Text)
			sb.AppendFormat("Start: {0}<br />", re.Start)
			sb.AppendFormat("End: {0}<br />", re.End)

			're.InnerHTML = "<b>Event details</b><br />Here is the right place to show details about the event with ID: " + re.Value + ". This text is loaded dynamically from the server.<br/>";
			re.InnerHTML = sb.ToString()
		ElseIf TypeOf e Is RenderTimeBubbleEventArgs Then
			Dim re As RenderTimeBubbleEventArgs = TryCast(e, RenderTimeBubbleEventArgs)
			e.InnerHTML = "<b>Time header details</b><br />From:" & re.Start & "<br />To: " & re.End
		ElseIf TypeOf e Is RenderCellBubbleEventArgs Then
			Dim re As RenderCellBubbleEventArgs = TryCast(e, RenderCellBubbleEventArgs)
			e.InnerHTML = "<b>Cell details</b><br />Column:" & re.ResourceId & "<br />From:" & re.Start & "<br />To: " & re.End
		End If
	End Sub

	Protected Sub DayPilotCalendar1_TimeRangeDoubleClick(ByVal sender As Object, ByVal e As TimeRangeDoubleClickEventArgs)

'		#Region "Simulation of database update"
		Dim dr As DataRow = table.NewRow()
		dr("start") = e.Start
		dr("end") = e.End
		dr("id") = Guid.NewGuid().ToString()
		dr("name") = "New event"

		table.Rows.Add(dr)
		table.AcceptChanges()
'		#End Region

		DayPilotCalendar1.DataBind()
		DayPilotCalendar1.Update("New event created.")
	End Sub
	Protected Sub ButtonExport_Click(ByVal sender As Object, ByVal e As EventArgs)
		Response.Clear()
		Response.ContentType = "image/png"
		Response.AddHeader("Content-Disposition", "attachment;filename=print.png")
		DayPilotCalendar1.DataBind()
		DayPilotCalendar1.Export(ImageFormat.Png).WriteTo(Response.OutputStream)
		Response.End()

	End Sub
	Protected Sub DayPilotCalendar1_TimeRangeMenuClick(ByVal sender As Object, ByVal e As TimeRangeMenuClickEventArgs)
		If e.Command = "Insert" Then
'			#Region "Simulation of database update"

			Dim dr As DataRow = table.NewRow()
			dr("start") = e.Start
			dr("end") = e.End
			dr("id") = Guid.NewGuid().ToString()
			dr("name") = "New event"

			table.Rows.Add(dr)
			table.AcceptChanges()
'			#End Region

			DayPilotCalendar1.DataBind()
			DayPilotCalendar1.Update()

		End If

	End Sub
	Protected Sub DayPilotCalendar1_Command(ByVal sender As Object, ByVal e As CommandEventArgs)
		Select Case e.Command
			Case "previous"
				DayPilotCalendar1.StartDate = DayPilotCalendar1.StartDate.AddDays(-7)
				DayPilotCalendar1.DataBind()
				DayPilotCalendar1.Update(CallBackUpdateType.Full)
			Case "navigate"
				Dim start As Date = CDate(e.Data("start"))
				Dim [end] As Date = CDate(e.Data("end"))

				DayPilotCalendar1.StartDate = start
				'DayPilotCalendar1.Days = (int) (end - start).TotalDays;

				DayPilotCalendar1.DataBind()
				DayPilotCalendar1.Update(CallBackUpdateType.Full)
		End Select


	End Sub
	Protected Sub DayPilotNavigator1_VisibleRangeChanged(ByVal sender As Object, ByVal e As EventArgs)
		DayPilotNavigator1.DataBind()
	End Sub

	Protected Sub DayPilotCalendar1_BeforeCellRender(ByVal sender As Object, ByVal e As BeforeCellRenderEventArgs)
		'e.BackgroundColor = "#a2a2a2";
	End Sub

	Protected Sub DayPilotCalendar1_HeaderClick(ByVal sender As Object, ByVal e As HeaderClickEventArgs)
	End Sub
End Class
