﻿Imports System
Imports System.Data
Imports System.Web.UI

Partial Public Class Calendar_New
	Inherits Page

	Private table As DataTable

	Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
		If Not IsPostBack Then
			TextBoxStart.Text = Convert.ToDateTime(Request.QueryString("start")).ToString()
			TextBoxEnd.Text = Convert.ToDateTime(Request.QueryString("end")).ToString()

			'TextBoxName.Focus();
		End If
	End Sub
	Protected Sub ButtonOK_Click(ByVal sender As Object, ByVal e As EventArgs)
		Dim start As Date = Convert.ToDateTime(TextBoxStart.Text)
		Dim [end] As Date = Convert.ToDateTime(TextBoxEnd.Text)
		Dim name As String = TextBoxName.Text

		dbInsertEvent(start, [end], name, Nothing)
		Modal.Close(Me, "OK")
	End Sub

	Private Function dbInsertEvent(ByVal start As Date, ByVal [end] As Date, ByVal name As String, ByVal resource As String) As String
		initData()

'NOTE: The variable id was renamed since Visual Basic does not handle local variables named the same as class members well:
		Dim id_Renamed As String = Guid.NewGuid().ToString()

'		#Region "Simulation of database update"

		Dim dr As DataRow = table.NewRow()
		dr("start") = start
		dr("end") = [end]
		dr("id") = id_Renamed
		dr("name") = name
		dr("column") = resource

		table.Rows.Add(dr)
		table.AcceptChanges()
'		#End Region

		Return id_Renamed
	End Function

	Protected Sub ButtonCancel_Click(ByVal sender As Object, ByVal e As EventArgs)
		Modal.Close(Me)
	End Sub

	Private Sub initData()
		If Session("AllFeatures") Is Nothing Then
			Session("AllFeatures") = DataGeneratorCalendar.GetData()
		End If
		table = DirectCast(Session("AllFeatures"), DataTable)
	End Sub

End Class
