﻿Imports System
Imports System.Data
Imports System.IO
Imports System.Web.UI
Imports DayPilot.Web.Ui
Imports DayPilot.Web.Ui.Enums
Imports DayPilot.Web.Ui.Events
Imports DayPilot.Web.Ui.Events.Bubble

Partial Public Class ResourcesDaysView
	Inherits Page

	Private table As DataTable

	Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
'		#Region "Data loading initialization"
		If Session("ResourcesDaysView") Is Nothing Then
			Session("ResourcesDaysView") = DataGeneratorCalendar.GetData()
		End If
		table = DirectCast(Session("ResourcesDaysView"), DataTable)
		DayPilotCalendar1.DataSource = Session("ResourcesDaysView")
'		#End Region

		defineColumns()

		If Not IsPostBack Then
			DataBind()
		End If
	End Sub

	Private Sub defineColumns()
		DayPilotCalendar1.Columns.Clear()

		Dim first As Date = DayPilotCalendar1.StartDate

		Dim resources() As String = {"A", "B", "C"}

		For Each res As String In resources

			Dim c As New Column(res, res) ' using the same Name and Value
			DayPilotCalendar1.Columns.Add(c)

			For j As Integer = 0 To 1
				Dim day As Date = first.AddDays(j)

				Dim subC As New Column(day.ToShortDateString(), res)
				subC.Date = day
				c.Children.Add(subC)
			Next j
		Next res
	End Sub


	Protected Sub DayPilotCalendar1_TimeRangeSelected(ByVal sender As Object, ByVal e As TimeRangeSelectedEventArgs)
		DayPilotCalendar1.Update()
	End Sub

	Protected Sub DayPilotCalendar1_EventResize(ByVal sender As Object, ByVal e As EventResizeEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			'dr["name"] = e.Resource;
			table.AcceptChanges()

		End If

'		#End Region

		DayPilotCalendar1.DataBind()
		DayPilotCalendar1.Update()

	End Sub
	Protected Sub DayPilotCalendar1_EventMove(ByVal sender As Object, ByVal e As EventMoveEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			dr("column") = e.NewResource
			table.AcceptChanges()
		End If

'		#End Region

		DayPilotCalendar1.DataBind()
		DayPilotCalendar1.Update()

	End Sub

	Protected Sub DayPilotBubble1_RenderContent(ByVal sender As Object, ByVal e As RenderEventArgs)
		If TypeOf e Is RenderResourceBubbleEventArgs Then
			Dim re As RenderResourceBubbleEventArgs = TryCast(e, RenderResourceBubbleEventArgs)
			e.InnerHTML = "<b>Resource header details</b><br />Value: " & re.ResourceId
		End If
	End Sub

	Protected Sub DayPilotCalendar1_Refresh(ByVal sender As Object, ByVal e As RefreshEventArgs)

		DayPilotCalendar1.StartDate = e.StartDate
		defineColumns()
		DayPilotCalendar1.DataBind()
		DayPilotCalendar1.Update(CallBackUpdateType.Full)
	End Sub

	Protected Sub DayPilotCalendar1_Command(ByVal sender As Object, ByVal e As CommandEventArgs)
		Select Case e.Command
			Case "previous"
				DayPilotCalendar1.StartDate = DayPilotCalendar1.StartDate.AddDays(-3)
			Case "next"
				DayPilotCalendar1.StartDate = DayPilotCalendar1.StartDate.AddDays(3)
			Case "today"
				DayPilotCalendar1.StartDate = Date.Today
		End Select

		defineColumns() ' required, the StartDate was changes
		DayPilotCalendar1.DataBind()
		DayPilotCalendar1.Update(CallBackUpdateType.Full)

	End Sub

	Protected Sub DayPilotCalendar1_BeforeCellRender(ByVal sender As Object, ByVal e As BeforeCellRenderEventArgs)
	End Sub
End Class
