﻿Imports System
Imports System.Data
Imports System.Text
Imports System.Web.UI
Imports DayPilot.Web.Ui
Imports DayPilot.Web.Ui.Enums
Imports DayPilot.Web.Ui.Events
Imports DayPilot.Web.Ui.Events.Bubble
Imports BeforeTimeHeaderRenderEventArgs = DayPilot.Web.Ui.Events.Calendar.BeforeTimeHeaderRenderEventArgs

Partial Public Class ResourcesView
	Inherits Page

	Private table As DataTable

	Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
'		#Region "Data loading initialization"
		If Session("ResourcesView") Is Nothing Then
			Session("ResourcesView") = DataGeneratorCalendar.GetData()
		End If
		table = DirectCast(Session("ResourcesView"), DataTable)
		DayPilotCalendar1.DataSource = Session("ResourcesView")
'		#End Region

		If Not IsPostBack Then
			DataBind()
		End If
	End Sub
	Protected Sub DayPilotCalendar1_TimeRangeSelected(ByVal sender As Object, ByVal e As TimeRangeSelectedEventArgs)
		DayPilotCalendar1.Update()
	End Sub

	Protected Sub DayPilotCalendar1_EventResize(ByVal sender As Object, ByVal e As EventResizeEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			table.AcceptChanges()

		End If

'		#End Region

		DayPilotCalendar1.DataBind()
		DayPilotCalendar1.Update()

	End Sub

	Protected Sub DayPilotCalendar1_BeforeCellRender(ByVal sender As Object, ByVal e As BeforeCellRenderEventArgs)
	End Sub

	Protected Sub DayPilotCalendar1_EventMove(ByVal sender As Object, ByVal e As EventMoveEventArgs)

'		#Region "Simulation of database update"

		'throw new Exception("old resource: " + e.OldResource);

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			dr("column") = e.NewResource
			table.AcceptChanges()

		End If

'		#End Region

		DayPilotCalendar1.DataBind()
		DayPilotCalendar1.UpdateWithMessage("Moved from " & e.OldResource & " to " & e.NewResource)

	End Sub

	Protected Sub DayPilotBubble1_RenderContent(ByVal sender As Object, ByVal e As RenderEventArgs)
		If TypeOf e Is RenderCellBubbleEventArgs Then
			Dim re As RenderCellBubbleEventArgs = TryCast(e, RenderCellBubbleEventArgs)
			e.InnerHTML = "<b>Cell details</b><br />Column:" & re.ResourceId & "<br />From:" & re.Start & "<br />To: " & re.End
		End If
	End Sub

	Protected Sub DayPilotCalendar1_OnBeforeTimeHeaderRender(ByVal ea As BeforeTimeHeaderRenderEventArgs)
		ea.Html = "Custom header"
	End Sub
End Class
