﻿Imports System
Imports System.Data
Imports System.IO
Imports System.Reflection
Imports DayPilot.Web.Ui

Partial Public Class Demo
	Inherits System.Web.UI.MasterPage

	'private string root;

	Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
	' prevent invalid ViewState errors in Firefox
		If Request.Browser.Browser = "Firefox" Then
			Response.Cache.SetNoStore()
		End If

		If Not IsPostBack Then
			Repeater1.DataBind()
			Repeater2.DataBind()
			DemoInfo.DataBind()
			SandboxInfo.DataBind()
		End If
	End Sub

	Protected ReadOnly Property MenuVisible() As Boolean
		Get
			Return root <> ResolveUrl("~/")
		End Get
	End Property

	Private ReadOnly Property root() As String
		Get
			Return Request.FilePath.Substring(0, Request.FilePath.LastIndexOf("/"c)) & "/"
		End Get
	End Property
'NOTE: The field tabs was renamed since Visual Basic does not allow fields to have the same name as other class members:
	Private tabs_Renamed As DataTable = Nothing
	Protected ReadOnly Property Tabs() As DataTable
		Get
			If tabs_Renamed Is Nothing Then
				Dim ds As New DataSet()
				ds.ReadXml(Server.MapPath("~/Navigation.config"))
				Dim dt As DataTable = ds.Tables("Item")

				For Each r As DataRow In dt.Rows
					Dim url As String = TryCast(r("url"), String)

					If url Is Nothing Then
						Continue For
					End If

					r("url") = ResolveUrl("~" & url)

					If root = ResolveUrl("~" & url) Then
						r("class") = "tab selected"
					Else
						r("class") = "tab"
					End If

					'r["url"] = normalized;
				Next r
				tabs_Renamed = dt
			End If

			Return tabs_Renamed

		End Get
	End Property

	Protected ReadOnly Property Description() As String
		Get
			Dim dt As DataTable = LocalNavigation.Tables("Description")
			If dt Is Nothing OrElse dt.Rows.Count = 0 Then
				Return String.Empty
			End If
			Return TryCast(dt.Rows(0)("text"), String)
		End Get

	End Property

'NOTE: The field localNavigation was renamed since Visual Basic does not allow fields to have the same name as other class members:
	Private localNavigation_Renamed As DataSet
	Private ReadOnly Property LocalNavigation() As DataSet
		Get
			If localNavigation_Renamed Is Nothing Then
				localNavigation_Renamed = New DataSet()
				localNavigation_Renamed.ReadXml(Server.MapPath("Navigation.config"))
			End If
			Return localNavigation_Renamed
		End Get
	End Property

	Protected ReadOnly Property Items() As DataTable
		Get
			Dim dt As DataTable = LocalNavigation.Tables("Item").Copy()

			For Each r As DataRow In dt.Rows
				Dim url As String = TryCast(r("url"), String)

				If url Is Nothing Then
					Continue For
				End If

				If Request.Path.ToUpper().IndexOf("/" & url.ToUpper()) <> -1 Then
					r("url") = ResolveUrl(root & url)
					r("class") &= " selected"
				Else
					r("url") = ResolveUrl(root & url)
					'r["class"] = "";
				End If
			Next r
			Return dt

		End Get
	End Property

	Protected Function GetLastUpdate() As String
		Dim v As Version = System.Reflection.Assembly.GetAssembly(GetType(DayPilotCalendar)).GetName().Version
'        DateTime update = File.GetCreationTime(Server.MapPath("~/updated.config"));
		Dim update As Date = File.GetLastWriteTime(Server.MapPath("~/bin/DayPilot.dll"))
		Dim hoursAgo As Integer = Convert.ToInt32(Math.Round((Date.Now.Subtract(update)).TotalHours))
		Dim ago As String

		Select Case hoursAgo
			Case 0
				ago = "right now"
			Case 1
				ago = "1 hour ago"
			Case Else
				ago = String.Format("{0} hours ago", hoursAgo)
		End Select

		Return String.Format("DayPilot Pro {0}", v)
	End Function

	Protected Function GetDownloadLink() As String
		Return String.Format("<a href='{0}'>{1}</a>", GetDownloadUrl(), GetDownloadName())
	End Function

	Protected Function GetDownloadUrl() As String
		If IsSandbox Then
			Return ResolveUrl(String.Format("~/{0}", GetDownloadName()))
		End If
		If IsDemo Then
			Return String.Format("/files/trial/{0}", GetDownloadName())
		End If
		Return GetDownloadName()
	End Function

	Protected Function GetDownloadName() As String
		Dim v As Version = System.Reflection.Assembly.GetAssembly(GetType(DayPilotCalendar)).GetName().Version
		Return String.Format("DayPilotProTrial-{0}.{1}.{2}.zip", v.Major, v.Minor, v.Build)
	End Function

	Protected ReadOnly Property IsSandbox() As Boolean
		Get
			Return Request.Path.ToLower().Contains("sandbox")
		End Get
	End Property

	Protected ReadOnly Property IsDemo() As Boolean
		Get
			Return Request.Path.ToLower().Contains("demo")
		End Get
	End Property

End Class
