﻿Imports System
Imports System.Collections
Imports System.Diagnostics
Imports DayPilot.Web.Ui
Imports DayPilot.Web.Ui.Data
Imports DayPilot.Web.Ui.Enums.Gantt
Imports DayPilot.Web.Ui.Events.Gantt

Partial Public Class Gantt_Default
	Inherits System.Web.UI.Page

	Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
		AddHandler DayPilotGantt1.BeforeCellRender, AddressOf DayPilotGantt1_BeforeCellRender
		AddHandler DayPilotGantt1.TaskMove, AddressOf DayPilotGantt1_OnTaskMove
		AddHandler DayPilotGantt1.Command, AddressOf DayPilotGantt1_Command
		AddHandler DayPilotGantt1.BeforeLinkRender, AddressOf DayPilotGantt1_BeforeLinkRender
		AddHandler DayPilotGantt1.BeforeTaskRender, AddressOf DayPilotGantt1_BeforeTaskRender
		AddHandler DayPilotGantt1.BeforeTimeHeaderRender, AddressOf DayPilotGantt1_BeforeTimeHeaderRender
		AddHandler DayPilotGantt1.TaskClick, AddressOf DayPilotGantt1_TaskClick
		AddHandler DayPilotGantt1.TaskMenuClick, AddressOf DayPilotGantt1_TaskMenuClick
		AddHandler DayPilotGantt1.LinkMenuClick, AddressOf DayPilotGantt1_LinkMenuClick

		If Not IsPostBack Then
			DayPilotGantt1.StartDate = Date.Today.AddDays(-10)
			DayPilotGantt1.ScrollTo(Date.Today)
			DayPilotGantt1.Days = 30
			LoadTasksAndLinks()
		End If
	End Sub

	Private Sub DayPilotGantt1_LinkMenuClick(ByVal sender As Object, ByVal e As LinkMenuClickEventArgs)
		DayPilotGantt1.Message("Command: " & e.Command & ", link from " & e.From & " to " & e.To)
	End Sub

	Private Sub DayPilotGantt1_TaskMenuClick(ByVal sender As Object, ByVal e As TaskMenuClickEventArgs)
		DayPilotGantt1.Message("Command: " & e.Command & ", task: " & e.Id)
	End Sub

	Private Sub DayPilotGantt1_TaskClick(ByVal sender As Object, ByVal e As TaskClickEventArgs)
'        DayPilotGantt1.Message("Clicked: " + e.Id);
		DayPilotGantt1.UpdateWithMessage("Clicked: " & e.Id)
	End Sub

	Private Sub DayPilotGantt1_BeforeTimeHeaderRender(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.BeforeTimeHeaderRenderEventArgs)
'        
'        if (e.Level == 0)
'        {
'            e.BackgroundColor = "#aaffaa";
'        }
'         
	End Sub

	Private Sub DayPilotGantt1_BeforeTaskRender(ByVal sender As Object, ByVal e As BeforeTaskRenderEventArgs)
		e.Box.BubbleHtml = "Complete: " & e.Complete & "%"
		e.Row.BubbleHtml = "Task Name: " & e.Text

		'e.Row.Areas.Add(new Area().Right(0).Top(0).Height(20).Width(20).BackgroundColor("red").ContextMenu("myMenu"));
	End Sub

	Private Sub DayPilotGantt1_BeforeLinkRender(ByVal sender As Object, ByVal e As BeforeLinkRenderEventArgs)
		'e.Color = "blue";
		'e.Style = LinkStyle.Dotted;
		'e.CssClass = "mylink";
	End Sub

	Private Sub LoadTasksAndLinks()
		DayPilotGantt1.Tasks.Clear()
		DayPilotGantt1.Links.Clear()

		Dim start As Date = Date.Today.AddDays(1)

		Dim group1 As New Task("Group 1", "G1", start, start.AddDays(1))
		group1.Tags("info") = "info"
		group1.Complete = 30
		group1.Children.Add(CreateTask("Task 1", "1", start, start.AddDays(1), 50))
		group1.Children.Add("Task 2", "2", start.AddDays(1), start.AddDays(2))
		group1.Children.Add(New Milestone("Milestone 1", "M1", start.AddDays(2)))
		DayPilotGantt1.Tasks.Add(group1)
		DayPilotGantt1.Links.Add("1", "2")

		start = start.AddDays(2)
		Dim group2 As New Task("Group 2", "G2", start, start.AddDays(1))
		group2.Tags("info") = "info"
		group2.Complete = 30
		group2.Children.Add(CreateTask("Task 1", "3", start, start.AddDays(1), 50))
		group2.Children.Add("Task 2", "4", start.AddDays(1), start.AddDays(2))
		group2.Children.Add(New Milestone("Milestone 2", "M2", start.AddDays(2)))
		DayPilotGantt1.Tasks.Add(group2)
		DayPilotGantt1.Links.Add("3", "4")

		DayPilotGantt1.Links.Add("G1", "G2")

	End Sub

	Private Function CreateTask(ByVal text As String, ByVal id As String, ByVal start As Date, ByVal [end] As Date, ByVal complete As Integer) As Task
		Dim task As New Task(text, id, start, [end])
		task.Complete = complete
		Return task
	End Function

	Private Sub DayPilotGantt1_Command(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.Gantt.CommandEventArgs)
		Select Case e.Command
			Case "goto"
				DayPilotGantt1.StartDate = Convert.ToDateTime(CStr(e.Data))
				DayPilotGantt1.Days = Date.DaysInMonth(DayPilotGantt1.StartDate.Year, DayPilotGantt1.StartDate.Month)
				LoadTasksAndLinks()
				DayPilotGantt1.UpdateWithMessage("Command received: " & e.Command)
			Case "clientstate"
				Dim filter As String = CStr(DayPilotGantt1.ClientState("filter"))
				DayPilotGantt1.UpdateWithMessage("filter: " & filter)

		End Select
	End Sub

	Private Sub DayPilotGantt1_BeforeCellRender(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.Gantt.BeforeCellRenderEventArgs)
'        
'        if (e.Start.DayOfWeek == DayOfWeek.Sunday)
'        {
'            e.BackgroundColor = "#ffaaaa";
'        }
'         
	End Sub

	Protected Sub DayPilotGantt1_OnTaskMove(ByVal sender As Object, ByVal e As TaskMoveEventArgs)
		DayPilotGantt1.UpdateWithMessage("Moved to " & e.NewStart)
	End Sub


End Class
