﻿Imports System
Imports System.Collections
Imports DayPilot.Web.Ui
Imports DayPilot.Web.Ui.Enums.Gantt
Imports DayPilot.Web.Ui.Events.Gantt

Partial Public Class Gantt_Large
	Inherits System.Web.UI.Page

	Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
		AddHandler DayPilotGantt1.BeforeCellRender, AddressOf DayPilotGantt1_BeforeCellRender
		AddHandler DayPilotGantt1.TaskMove, AddressOf DayPilotGantt1_OnTaskMove
		AddHandler DayPilotGantt1.Command, AddressOf DayPilotGantt1_Command
		AddHandler DayPilotGantt1.BeforeLinkRender, AddressOf DayPilotGantt1_BeforeLinkRender
		AddHandler DayPilotGantt1.BeforeTaskRender, AddressOf DayPilotGantt1_BeforeTaskRender
		AddHandler DayPilotGantt1.BeforeTimeHeaderRender, AddressOf DayPilotGantt1_BeforeTimeHeaderRender
		AddHandler DayPilotGantt1.TaskClick, AddressOf DayPilotGantt1_TaskClick
		AddHandler DayPilotGantt1.TaskMenuClick, AddressOf DayPilotGantt1_TaskMenuClick

		If Not IsPostBack Then
			DayPilotGantt1.StartDate = Date.Today.AddDays(-1)
			DayPilotGantt1.Days = 30
			LoadTasksAndLinks()
		End If
	End Sub

	Private Sub DayPilotGantt1_TaskMenuClick(ByVal sender As Object, ByVal e As TaskMenuClickEventArgs)
		DayPilotGantt1.UpdateWithMessage("Command: " & e.Command & ", task: " & e.Id)
	End Sub

	Private Sub DayPilotGantt1_TaskClick(ByVal sender As Object, ByVal e As TaskClickEventArgs)
		DayPilotGantt1.UpdateWithMessage("Clicked: " & e.Id)
	End Sub

	Private Sub DayPilotGantt1_BeforeTimeHeaderRender(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.BeforeTimeHeaderRenderEventArgs)
'        
'        if (e.Level == 0)
'        {
'            e.BackgroundColor = "#aaffaa";
'        }
'         
	End Sub

	Private Sub DayPilotGantt1_BeforeTaskRender(ByVal sender As Object, ByVal e As BeforeTaskRenderEventArgs)
'        
'        e.Box.Html = "test";
'        e.Box.HtmlRight = "right";
'         * 
	End Sub

	Private Sub DayPilotGantt1_BeforeLinkRender(ByVal sender As Object, ByVal e As BeforeLinkRenderEventArgs)
		'e.Color = "blue";
		'e.Style = LinkStyle.Dotted;
		'e.CssClass = "mylink";
	End Sub

	Private Sub LoadTasksAndLinks()
		DayPilotGantt1.DataSource = DataGeneratorGantt.GetDataLarge()
		DayPilotGantt1.DataIdField = "id"
		DayPilotGantt1.DataTextField = "text"
		DayPilotGantt1.DataStartField = "start"
		DayPilotGantt1.DataEndField = "end"
		DayPilotGantt1.DataParentField = "parent"
		DayPilotGantt1.DataBind()

		DayPilotGantt1.Links.Clear()
		DayPilotGantt1.Links.Add("1", "2")
	End Sub

	Private Function CreateTask(ByVal text As String, ByVal id As String, ByVal start As Date, ByVal [end] As Date, ByVal complete As Integer) As Task
		Dim task As New Task(text, id, start, [end])
		task.Complete = complete
		Return task
	End Function

	Private Sub DayPilotGantt1_Command(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.Gantt.CommandEventArgs)
		If e.Command = "goto" Then
			DayPilotGantt1.StartDate = Convert.ToDateTime(CStr(e.Data))
			DayPilotGantt1.Days = Date.DaysInMonth(DayPilotGantt1.StartDate.Year, DayPilotGantt1.StartDate.Month)
			LoadTasksAndLinks()
			DayPilotGantt1.UpdateWithMessage("Command received: " & e.Command)
		End If
	End Sub

	Private Sub DayPilotGantt1_BeforeCellRender(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.Gantt.BeforeCellRenderEventArgs)
'        
'        if (e.Start.DayOfWeek == DayOfWeek.Sunday)
'        {
'            e.BackgroundColor = "#ffaaaa";
'        }
'         
	End Sub

	Protected Sub DayPilotGantt1_OnTaskMove(ByVal sender As Object, ByVal e As TaskMoveEventArgs)
		DayPilotGantt1.UpdateWithMessage("Moved to " & e.NewStart)
	End Sub
End Class
