﻿Imports System
Imports System.Collections
Imports DayPilot.Web.Ui
Imports DayPilot.Web.Ui.Enums.Gantt
Imports DayPilot.Web.Ui.Events.Gantt

Partial Public Class Gantt_TaskSyncing
	Inherits System.Web.UI.Page

	Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
		AddHandler DayPilotGantt1.BeforeCellRender, AddressOf DayPilotGantt1_BeforeCellRender
		AddHandler DayPilotGantt1.TaskMove, AddressOf DayPilotGantt1_OnTaskMove
		AddHandler DayPilotGantt1.Command, AddressOf DayPilotGantt1_Command
		AddHandler DayPilotGantt1.BeforeLinkRender, AddressOf DayPilotGantt1_BeforeLinkRender
		AddHandler DayPilotGantt1.BeforeTaskRender, AddressOf DayPilotGantt1_BeforeTaskRender
		AddHandler DayPilotGantt1.BeforeTimeHeaderRender, AddressOf DayPilotGantt1_BeforeTimeHeaderRender
		AddHandler DayPilotGantt1.TaskClick, AddressOf DayPilotGantt1_TaskClick
		AddHandler DayPilotGantt1.TaskMenuClick, AddressOf DayPilotGantt1_TaskMenuClick
		AddHandler DayPilotGantt1.LinkMenuClick, AddressOf DayPilotGantt1_LinkMenuClick

		If Not IsPostBack Then
			DayPilotGantt1.StartDate = Date.Today.AddDays(-1)
			DayPilotGantt1.Days = 30
			LoadTasksAndLinks()
		End If
	End Sub

	Private Sub DayPilotGantt1_LinkMenuClick(ByVal sender As Object, ByVal e As LinkMenuClickEventArgs)
		DayPilotGantt1.Message("Command: " & e.Command & ", link from " & e.From & " to " & e.To)
	End Sub

	Private Sub DayPilotGantt1_TaskMenuClick(ByVal sender As Object, ByVal e As TaskMenuClickEventArgs)
		DayPilotGantt1.Message("Command: " & e.Command & ", task: " & e.Id)
	End Sub

	Private Sub DayPilotGantt1_TaskClick(ByVal sender As Object, ByVal e As TaskClickEventArgs)
		DayPilotGantt1.Message("Clicked: " & e.Id)
	End Sub

	Private Sub DayPilotGantt1_BeforeTimeHeaderRender(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.BeforeTimeHeaderRenderEventArgs)
'        
'        if (e.Level == 0)
'        {
'            e.BackgroundColor = "#aaffaa";
'        }
'         
	End Sub

	Private Sub DayPilotGantt1_BeforeTaskRender(ByVal sender As Object, ByVal e As BeforeTaskRenderEventArgs)
		If e.Tags.ContainsKey("color") Then
			e.Box.BarBackColor = "#ddd"
			e.Box.BarColor = e.Tags("color")
		End If
	End Sub

	Private Sub DayPilotGantt1_BeforeLinkRender(ByVal sender As Object, ByVal e As BeforeLinkRenderEventArgs)
		If e.Tags.ContainsKey("color") Then
			e.Color = e.Tags("color")
		End If

	End Sub

	Private Sub LoadTasksAndLinks()
		DayPilotGantt1.Tasks.Clear()
		DayPilotGantt1.Links.Clear()

		Dim group As New Task("Group 1", "G1", Date.Now, Date.Now.AddDays(1))
		group.Tags("info") = "info"
		group.Complete = 30

		group.Children.Add(CreateTask("Task 1", "1", Date.Now, Date.Now.AddDays(1), 50))
		group.Children.Add("Task 2", "2", Date.Now, Date.Now.AddDays(1))
		group.Children.Add(New Milestone("Milestone 1", "M1", Date.Now.AddHours(1)))

		DayPilotGantt1.Tasks.Add(group)

		DayPilotGantt1.Links.Add(CreateLink("1", "2", "green"))
	End Sub

	Private Function CreateLink(ByVal from As String, ByVal [to] As String, ByVal color As String) As Link
		Dim link As New Link()
		link.From = from
		link.To = [to]
		link.Tags("color") = color
		Return link
	End Function

	Private Function CreateTask(ByVal text As String, ByVal id As String, ByVal start As Date, ByVal [end] As Date, ByVal complete As Integer) As Task
		Dim task As New Task(text, id, start, [end])
		task.Complete = complete
		task.Tags("color") = "red"
		Return task
	End Function

	Private Sub DayPilotGantt1_Command(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.Gantt.CommandEventArgs)
		If e.Command = "goto" Then
			DayPilotGantt1.StartDate = Convert.ToDateTime(CStr(e.Data))
			DayPilotGantt1.Days = Date.DaysInMonth(DayPilotGantt1.StartDate.Year, DayPilotGantt1.StartDate.Month)
			'LoadTasksAndLinks();
			DayPilotGantt1.UpdateWithMessage("Command received: " & e.Command)
		End If
	End Sub

	Private Sub DayPilotGantt1_BeforeCellRender(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.Gantt.BeforeCellRenderEventArgs)
	End Sub

	Protected Sub DayPilotGantt1_OnTaskMove(ByVal sender As Object, ByVal e As TaskMoveEventArgs)
		DayPilotGantt1.UpdateWithMessage("Moved to " & e.NewStart)
	End Sub
End Class
