﻿Imports System
Imports System.Data
Imports System.Drawing
Imports DayPilot.Web.Ui.Data
Imports DayPilot.Web.Ui.Enums
Imports DayPilot.Web.Ui.Events
Imports DayPilot.Web.Ui.Events.Bubble

Partial Public Class Month_CustomRendering
	Inherits System.Web.UI.Page

	Private table As DataTable

	Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
		initData()
		If Not IsPostBack Then
			DayPilotMonth1.DataSource = getData(DayPilotMonth1.VisibleStart, DayPilotMonth1.VisibleEnd, Nothing)
			DataBind()
		End If

	End Sub

	Protected Sub DayPilotCalendar1_EventMenuClick(ByVal sender As Object, ByVal e As EventMenuClickEventArgs)
		If e.Command = "Delete" Then
'			#Region "Simulation of database update"
			Dim dr As DataRow = table.Rows.Find(e.Id)

			If dr IsNot Nothing Then
				table.Rows.Remove(dr)
				table.AcceptChanges()
			End If
'			#End Region

			DayPilotMonth1.DataSource = getData(DayPilotMonth1.VisibleStart, DayPilotMonth1.VisibleEnd, Nothing)
			DayPilotMonth1.DataBind()
			DayPilotMonth1.Update()
		End If
	End Sub
	Protected Sub DayPilotMonth1_EventMove(ByVal sender As Object, ByVal e As EventMoveEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			'dr["column"] = e.NewResource;
			table.AcceptChanges()
		Else ' moved from outside
			dr = table.NewRow()
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			dr("id") = e.Id
			dr("name") = e.Text
			'dr["column"] = e.NewResource;

			table.Rows.Add(dr)
			table.AcceptChanges()
		End If

'		#End Region

		DayPilotMonth1.DataSource = getData(DayPilotMonth1.VisibleStart, DayPilotMonth1.VisibleEnd, Nothing)
		DayPilotMonth1.DataBind()
		DayPilotMonth1.Update("Event moved.")

	End Sub
	Protected Sub DayPilotMonth1_EventResize(ByVal sender As Object, ByVal e As EventResizeEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			table.AcceptChanges()
		End If

'		#End Region

		DayPilotMonth1.DataSource = getData(DayPilotMonth1.VisibleStart, DayPilotMonth1.VisibleEnd, Nothing)
		DayPilotMonth1.DataBind()
		DayPilotMonth1.Update("Event resized")

	End Sub
	Protected Sub DayPilotMonth1_BeforeCellRender(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.Month.BeforeCellRenderEventArgs)

		If e.Start = Date.Today Then
			e.HeaderHTML = String.Format("<span style='font-weight:bold'>{0}</span>", e.Start.Day)
			e.HeaderBackColor = "#FFD3BD"
		End If

	End Sub

	Protected Sub DayPilotMonth1_BeforeHeaderRender(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.Month.BeforeHeaderRenderEventArgs)
'     e.InnerHTML = "<b>" + e.InnerHTML + "</b>";
	End Sub

	Protected Sub DayPilotMonth1_TimeRangeSelected(ByVal sender As Object, ByVal e As TimeRangeSelectedEventArgs)
'		#Region "Simulation of database update"
		Dim dr As DataRow = table.NewRow()
		dr("start") = e.Start
		dr("end") = e.End
		dr("id") = Guid.NewGuid().ToString()
		dr("name") = "New event"

		table.Rows.Add(dr)
		table.AcceptChanges()
'		#End Region

		DayPilotMonth1.DataSource = getData(DayPilotMonth1.VisibleStart, DayPilotMonth1.VisibleEnd, Nothing)
		DayPilotMonth1.DataBind()
		DayPilotMonth1.Update()
	End Sub
	Protected Sub DayPilotMonth1_BeforeEventRender(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.Month.BeforeEventRenderEventArgs)
'NOTE: The variable id was renamed since Visual Basic does not handle local variables named the same as class members well:
		Dim id_Renamed As Integer = Nothing

		If Not Int32.TryParse(e.Id, id_Renamed) Then
			Return
		End If

		If id_Renamed < 5 Then
			e.BackgroundColor = "#BDE9FF"
		ElseIf id_Renamed < 10 Then
			e.BackgroundColor = "#B3FFC6"
		ElseIf id_Renamed = 11 Then
			e.Html = String.Format("<img src='../Media/linked/red8x8.gif' width='8' height='8' valign='absmiddle' /> {0}", e.Html)
		End If

'        
'        int padding = 2;
'        e.Areas.Add(new Area().Left(50).Top(padding).Right(50).Bottom(padding).Html(e.Html).Visible());
'        e.Areas.Add(new Area().Left(padding).Top(padding).Width(50).Bottom(padding).Html(e.Start.ToString("h:mm tt")).Visible().Style("color: #666; font-size: 8pt;"));
'        e.Areas.Add(new Area().Right(padding).Top(padding).Width(50).Bottom(padding).Html(e.End.ToString("h:mm tt")).Visible().Style("color: #666; font-size: 8pt;"));
'        e.Html = "&nbsp;";
'         
	End Sub

	Protected Sub DayPilotBubble1_RenderContent(ByVal sender As Object, ByVal e As RenderEventArgs)
		If TypeOf e Is RenderEventBubbleEventArgs Then
			Dim re As RenderEventBubbleEventArgs = TryCast(e, RenderEventBubbleEventArgs)
			re.InnerHTML = "<b>Event details</b><br />Here is the right place to show details about the event with ID: " & re.Value & ". This text is loaded dynamically from the server."
		End If
	End Sub

	Protected Sub DayPilotMonth1_Command(ByVal sender As Object, ByVal e As CommandEventArgs)
		  Select Case e.Command
			Case "next"
				DayPilotMonth1.StartDate = DayPilotMonth1.StartDate.AddMonths(1)
			Case "previous"
				DayPilotMonth1.StartDate = DayPilotMonth1.StartDate.AddMonths(-1)
			Case "today"
				DayPilotMonth1.StartDate = New Date(Date.Today.Year, Date.Today.Month, 1)
		  End Select

		DayPilotMonth1.DataSource = getData(DayPilotMonth1.VisibleStart, DayPilotMonth1.VisibleEnd, Nothing)
		DayPilotMonth1.DataBind()
		DayPilotMonth1.Update(CallBackUpdateType.Full)
	End Sub

	''' <summary>
	''' Make sure a copy of the data is in the Session so users can try changes on their own copy.
	''' </summary>
	Private Sub initData()
		If Session("MonthCustomRendering") Is Nothing Then
			Session("MonthCustomRendering") = DataGeneratorMonth.GetData()
		End If

		table = DirectCast(Session("MonthCustomRendering"), DataTable)
	End Sub

	''' <summary>
	''' This method should normally load the data from the database.
	''' We will load our copy from a Session, just simulating a database.
	''' </summary>
	''' <param name="start"></param>
	''' <param name="end"></param>
	''' <param name="filter"></param>
	''' <returns></returns>
	Private Function getData(ByVal start As Date, ByVal [end] As Date, ByVal filter As String) As DataTable
		Dim [select] As String
		If String.IsNullOrEmpty(filter) Then
			[select] = String.Format("NOT (([end] <= '{0:s}') OR ([start] >= '{1:s}'))", start, [end], filter)
		Else
			[select] = String.Format("NOT (([end] <= '{0:s}') OR ([start] >= '{1:s}')) and [name] like '%{2}%'", start, [end], filter)
			'            throw new Exception(select);
		End If


		Dim rows() As DataRow = table.Select([select])

		Dim filtered As DataTable = table.Clone()

		For Each r As DataRow In rows
			filtered.ImportRow(r)
		Next r

		Return filtered
	End Function


End Class
