﻿Imports System
Imports System.Data
Imports System.Drawing
Imports System.Drawing.Drawing2D
Imports System.Drawing.Imaging
Imports System.Drawing.Text
Imports System.IO
Imports DayPilot.Web.Ui.Enums
Imports DayPilot.Web.Ui.Events
Imports DayPilot.Web.Ui.Events.Bubble

Partial Public Class Month_ImageExport
	Inherits System.Web.UI.Page

	Private table As DataTable

	Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
		initData()
		If Not IsPostBack Then
			DayPilotMonth1.DataSource = getData(DayPilotMonth1.VisibleStart, DayPilotMonth1.VisibleEnd, CStr(DayPilotMonth1.ClientState("filter")))
			DayPilotNavigator1.DataSource = getData(DayPilotNavigator1.VisibleStart, DayPilotNavigator1.VisibleEnd, Nothing)
			DataBind()
		End If
	End Sub

	Protected Sub DayPilotCalendar1_EventMenuClick(ByVal sender As Object, ByVal e As EventMenuClickEventArgs)

		If e.Command = "Delete" Then
'			#Region "Simulation of database update"
			Dim dr As DataRow = table.Rows.Find(e.Id)

			If dr IsNot Nothing Then
				table.Rows.Remove(dr)
				table.AcceptChanges()
			End If
'			#End Region

			DayPilotMonth1.DataSource = getData(DayPilotMonth1.VisibleStart, DayPilotMonth1.VisibleEnd, CStr(DayPilotMonth1.ClientState("filter")))
			DayPilotMonth1.DataBind()
			DayPilotMonth1.Update()
		End If
	End Sub
	Protected Sub DayPilotMonth1_EventMove(ByVal sender As Object, ByVal e As EventMoveEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			'dr["column"] = e.NewResource;
			table.AcceptChanges()
		Else ' moved from outside
			dr = table.NewRow()
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			dr("id") = e.Id
			dr("name") = e.Text
			'dr["column"] = e.NewResource;

			table.Rows.Add(dr)
			table.AcceptChanges()
		End If

'		#End Region

		DayPilotMonth1.DataSource = getData(DayPilotMonth1.VisibleStart, DayPilotMonth1.VisibleEnd, CStr(DayPilotMonth1.ClientState("filter")))
		DayPilotMonth1.DataBind()
		DayPilotMonth1.Update("Event moved.")

	End Sub
	Protected Sub DayPilotMonth1_EventResize(ByVal sender As Object, ByVal e As EventResizeEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			table.AcceptChanges()
		End If

'		#End Region

		DayPilotMonth1.DataSource = getData(DayPilotMonth1.VisibleStart, DayPilotMonth1.VisibleEnd, CStr(DayPilotMonth1.ClientState("filter")))
		DayPilotMonth1.DataBind()
		DayPilotMonth1.Update("Event resized")

	End Sub

	Protected Sub DayPilotMonth1_TimeRangeSelected(ByVal sender As Object, ByVal e As TimeRangeSelectedEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.NewRow()
		dr("start") = e.Start
		dr("end") = e.End
		dr("id") = Guid.NewGuid().ToString()
		dr("name") = "New event"

		table.Rows.Add(dr)
		table.AcceptChanges()
'		#End Region

		DayPilotMonth1.DataSource = getData(DayPilotMonth1.VisibleStart, DayPilotMonth1.VisibleEnd, CStr(DayPilotMonth1.ClientState("filter")))
		DayPilotMonth1.DataBind()
		DayPilotMonth1.Update()
	End Sub
	Protected Sub DayPilotMonth1_BeforeEventRender(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.Month.BeforeEventRenderEventArgs)
	End Sub

	Protected Sub DayPilotBubble1_RenderContent(ByVal sender As Object, ByVal e As RenderEventArgs)
		If TypeOf e Is RenderEventBubbleEventArgs Then
			Dim re As RenderEventBubbleEventArgs = TryCast(e, RenderEventBubbleEventArgs)
			re.InnerHTML = "<b>Event details</b><br />Here is the right place to show details about the event with ID: " & re.Value & ". This text is loaded dynamically from the server."
		End If
	End Sub

	Protected Sub DayPilotNavigator1_VisibleRangeChanged(ByVal sender As Object, ByVal e As EventArgs)
		DayPilotNavigator1.DataSource = getData(DayPilotNavigator1.VisibleStart, DayPilotNavigator1.VisibleEnd, CStr(DayPilotMonth1.ClientState("filter")))
		DayPilotNavigator1.DataBind()
	End Sub

	Protected Sub DayPilotMonth1_Command(ByVal sender As Object, ByVal e As CommandEventArgs)

		Select Case e.Command
			Case "navigate"
				DayPilotMonth1.StartDate = CDate(e.Data("start"))
				DayPilotMonth1.DataSource = getData(DayPilotMonth1.VisibleStart, DayPilotMonth1.VisibleEnd, CStr(DayPilotMonth1.ClientState("filter")))
				DayPilotMonth1.DataBind()
				DayPilotMonth1.Update(CallBackUpdateType.Full)
			Case "filter"
				DayPilotMonth1.DataSource = getData(DayPilotMonth1.VisibleStart, DayPilotMonth1.VisibleEnd, CStr(DayPilotMonth1.ClientState("filter")))
				DayPilotMonth1.DataBind()
				DayPilotMonth1.Update(CallBackUpdateType.EventsOnly)
		End Select

	End Sub

	''' <summary>
	''' This method should normally load the data from the database.
	''' We will load our copy from a Session, just simulating a database.
	''' </summary>
	''' <param name="start"></param>
	''' <param name="end"></param>
	''' <param name="filter"></param>
	''' <returns></returns>
	Private Function getData(ByVal start As Date, ByVal [end] As Date, ByVal filter As String) As DataTable
		Dim [select] As String
		If String.IsNullOrEmpty(filter) Then
			[select] = String.Format("NOT (([end] <= '{0:s}') OR ([start] >= '{1:s}'))", start, [end], filter)
		Else
			[select] = String.Format("NOT (([end] <= '{0:s}') OR ([start] >= '{1:s}')) and [name] like '%{2}%'", start, [end], filter)
'            throw new Exception(select);
		End If


		Dim rows() As DataRow = table.Select([select])

		Dim filtered As DataTable = table.Clone()

		For Each r As DataRow In rows
			filtered.ImportRow(r)
		Next r

		Return filtered
	End Function

	''' <summary>
	''' Make sure a copy of the data is in the Session so users can try changes on their own copy.
	''' </summary>
	Private Sub initData()
		If Session("MonthView") Is Nothing Then
			Session("MonthView") = DataGeneratorMonth.GetData()
		End If

		table = DirectCast(Session("MonthView"), DataTable)
	End Sub

	Protected Sub ButtonExport_Click(ByVal sender As Object, ByVal e As EventArgs)
		DayPilotMonth1.LoadStylesDefaultTheme()
		DayPilotMonth1.DataSource = getData(DayPilotMonth1.VisibleStart, DayPilotMonth1.VisibleEnd, CStr(DayPilotMonth1.ClientState("filter")))
		DayPilotMonth1.DataBind()

		Response.Clear()
		Response.ContentType = "image/png"
		Response.AddHeader("Content-Disposition", "attachment;filename=print.png")
		DayPilotMonth1.Export(ImageFormat.Png).WriteTo(Response.OutputStream)
		Response.End()
	End Sub

	Protected Sub ButtonExportHeader_Click(ByVal sender As Object, ByVal e As EventArgs)
		DayPilotMonth1.DataSource = getData(DayPilotMonth1.VisibleStart, DayPilotMonth1.VisibleEnd, CStr(DayPilotMonth1.ClientState("filter")))
		DayPilotMonth1.DataBind()

		DayPilotMonth1.LoadStylesDefaultTheme()

		Response.Clear()
		Response.ContentType = "image/png"
		Response.AddHeader("content-disposition", "attachment;filename=print.png")

		Dim width As Integer = 1000
		Dim height As Integer = 1000

		Dim bmp As New Bitmap(width, height)
		Dim g As Graphics = Graphics.FromImage(bmp)
		g.SmoothingMode = SmoothingMode.AntiAlias
		g.TextRenderingHint = TextRenderingHint.AntiAlias

		Dim cal As Image = DayPilotMonth1.ExportBitmap()
		g.DrawImage(cal, 0, 50)

'NOTE: The variable title was renamed since Visual Basic does not handle local variables named the same as class members well:
		Dim title_Renamed As String = String.Format("{0:MMMM yyyy}", DayPilotMonth1.StartDate)
		Dim font As New Font("Tahoma", 16, GraphicsUnit.Point)
		Dim brush As Brush = New SolidBrush(Color.Black)
		g.DrawString(title_Renamed, font, brush, 0, 0)

		' PNG requires random access to the output stream
		Using mem As New MemoryStream()
			bmp.Save(mem, ImageFormat.Png)
			mem.WriteTo(Response.OutputStream)
		End Using

		Response.End()
	End Sub

	Protected Sub DayPilotMonth1_BeforeCellRender(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.Month.BeforeCellRenderEventArgs)
	End Sub
End Class
