﻿Imports System
Imports System.Data
Imports DayPilot.Web.Ui.Events
Imports DayPilot.Web.Ui.Events.Bubble

Partial Public Class Month_Localization
	Inherits System.Web.UI.Page

	Private table As DataTable

	Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
'		#Region "Data loading initialization"
		If Session("MonthView") Is Nothing Then
			Session("MonthView") = DataGeneratorMonth.GetData()
		End If
		table = DirectCast(Session("MonthView"), DataTable)
		DayPilotMonth1.DataSource = Session("MonthView")
'		#End Region

		If Not IsPostBack Then
			DataBind()
		End If
	End Sub

	Protected Sub DayPilotCalendar1_EventMenuClick(ByVal sender As Object, ByVal e As EventMenuClickEventArgs)

		If e.Command = "Delete" Then
'			#Region "Simulation of database update"
			Dim dr As DataRow = table.Rows.Find(e.Id)

			If dr IsNot Nothing Then
				table.Rows.Remove(dr)
				table.AcceptChanges()
			End If
'			#End Region

			DayPilotMonth1.DataBind()
			DayPilotMonth1.Update()
		End If
	End Sub
	Protected Sub DayPilotMonth1_EventMove(ByVal sender As Object, ByVal e As EventMoveEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			'dr["column"] = e.NewResource;
			table.AcceptChanges()
		Else ' moved from outside
			dr = table.NewRow()
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			dr("id") = e.Id
			dr("name") = e.Text
			'dr["column"] = e.NewResource;

			table.Rows.Add(dr)
			table.AcceptChanges()
		End If

'		#End Region

		DayPilotMonth1.DataBind()
		DayPilotMonth1.Update("Event moved.")

	End Sub
	Protected Sub DayPilotMonth1_EventResize(ByVal sender As Object, ByVal e As EventResizeEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			table.AcceptChanges()
		End If

'		#End Region

		DayPilotMonth1.DataBind()
		DayPilotMonth1.Update("Event resized")

	End Sub
	Protected Sub DayPilotMonth1_BeforeCellRender(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.Month.BeforeCellRenderEventArgs)

		If e.Start = Date.Today Then
			e.HeaderBackColor = "#FFD9CC"
		End If

	End Sub

	Protected Sub DayPilotMonth1_BeforeHeaderRender(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.Month.BeforeHeaderRenderEventArgs)
	End Sub

	Protected Sub DayPilotMonth1_TimeRangeSelected(ByVal sender As Object, ByVal e As TimeRangeSelectedEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.NewRow()
		dr("start") = e.Start
		dr("end") = e.End
		dr("id") = Guid.NewGuid().ToString()
		dr("name") = "New event"

		table.Rows.Add(dr)
		table.AcceptChanges()
'		#End Region

		DayPilotMonth1.DataBind()
		DayPilotMonth1.Update()
	End Sub
	Protected Sub DayPilotMonth1_BeforeEventRender(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.Month.BeforeEventRenderEventArgs)
		If e.Id = "7" Then
			e.ContextMenuClientName = "test"
		End If
	End Sub

	Protected Sub DayPilotBubble1_RenderContent(ByVal sender As Object, ByVal e As RenderEventArgs)
		If TypeOf e Is RenderEventBubbleEventArgs Then
			Dim re As RenderEventBubbleEventArgs = TryCast(e, RenderEventBubbleEventArgs)
			re.InnerHTML = "<b>Event details</b><br />Here is the right place to show details about the event with ID: " & re.Value & ". This text is loaded dynamically from the server."
		End If
	End Sub

	Protected Sub DayPilotMonth1_Refresh(ByVal sender As Object, ByVal e As RefreshEventArgs)
		DayPilotMonth1.StartDate = e.StartDate
		DayPilotMonth1.DataBind()
		DayPilotMonth1.Update()

	End Sub
	Protected Sub ButtonChange_Click(ByVal sender As Object, ByVal e As EventArgs)
		Culture = DropDownList1.SelectedValue
		DataBind()
	End Sub
End Class
