﻿Imports System
Imports System.Data
Imports DayPilot.Utils
Imports DayPilot.Web.Ui.Events
Imports DayPilot.Web.Ui.Events.Bubble

Partial Public Class Month_ThemeWhite
	Inherits System.Web.UI.Page

	Private table As DataTable

	Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
		initData()
		If Not IsPostBack Then
			DayPilotMonth1.DataSource = getData(DayPilotMonth1.VisibleStart, DayPilotMonth1.VisibleEnd, CStr(DayPilotMonth1.ClientState("filter")))
			DayPilotNavigator1.DataSource = getData(DayPilotNavigator1.VisibleStart, DayPilotNavigator1.VisibleEnd, Nothing)
			DataBind()
		End If
	End Sub

	Protected Sub DayPilotCalendar1_EventMenuClick(ByVal sender As Object, ByVal e As EventMenuClickEventArgs)

		If e.Command = "Delete" Then
'			#Region "Simulation of database update"
			Dim dr As DataRow = table.Rows.Find(e.Id)

			If dr IsNot Nothing Then
				table.Rows.Remove(dr)
				table.AcceptChanges()
			End If
'			#End Region

			DayPilotMonth1.DataSource = getData(DayPilotMonth1.VisibleStart, DayPilotMonth1.VisibleEnd, CStr(DayPilotMonth1.ClientState("filter")))
			DayPilotMonth1.DataBind()
			DayPilotMonth1.Update()
		End If
	End Sub
	Protected Sub DayPilotMonth1_EventMove(ByVal sender As Object, ByVal e As EventMoveEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			'dr["column"] = e.NewResource;
			table.AcceptChanges()
		Else ' moved from outside
			dr = table.NewRow()
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			dr("id") = e.Id
			dr("name") = e.Text
			'dr["column"] = e.NewResource;

			table.Rows.Add(dr)
			table.AcceptChanges()
		End If

'		#End Region

		DayPilotMonth1.DataSource = getData(DayPilotMonth1.VisibleStart, DayPilotMonth1.VisibleEnd, CStr(DayPilotMonth1.ClientState("filter")))
		DayPilotMonth1.DataBind()
		DayPilotMonth1.UpdateWithMessage("Event moved.")

	End Sub
	Protected Sub DayPilotMonth1_EventResize(ByVal sender As Object, ByVal e As EventResizeEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			table.AcceptChanges()
		End If

'		#End Region

		DayPilotMonth1.DataSource = getData(DayPilotMonth1.VisibleStart, DayPilotMonth1.VisibleEnd, CStr(DayPilotMonth1.ClientState("filter")))
		DayPilotMonth1.DataBind()
		DayPilotMonth1.UpdateWithMessage("Event resized")

	End Sub

	Protected Sub DayPilotMonth1_TimeRangeSelected(ByVal sender As Object, ByVal e As TimeRangeSelectedEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.NewRow()
		dr("start") = e.Start
		dr("end") = e.End
		dr("id") = Guid.NewGuid().ToString()
		dr("name") = "New event"

		table.Rows.Add(dr)
		table.AcceptChanges()
'		#End Region

		DayPilotMonth1.DataSource = getData(DayPilotMonth1.VisibleStart, DayPilotMonth1.VisibleEnd, CStr(DayPilotMonth1.ClientState("filter")))
		DayPilotMonth1.DataBind()
		DayPilotMonth1.Update()
	End Sub
	Protected Sub DayPilotMonth1_BeforeEventRender(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.Month.BeforeEventRenderEventArgs)
		If e.Id = "12" Then
			e.ContextMenuClientName = "menu2"
			e.BubbleHtml = "test"
		End If

	End Sub

	Protected Sub DayPilotBubble1_RenderContent(ByVal sender As Object, ByVal e As RenderEventArgs)
		If TypeOf e Is RenderEventBubbleEventArgs Then
			Dim re As RenderEventBubbleEventArgs = TryCast(e, RenderEventBubbleEventArgs)
			re.InnerHTML = "<b>Event details</b><br />Here is the right place to show details about the event with ID: " & re.Value & ". This text is loaded dynamically from the server."
		End If
	End Sub

	Protected Sub DayPilotNavigator1_VisibleRangeChanged(ByVal sender As Object, ByVal e As EventArgs)
		DayPilotNavigator1.DataSource = getData(DayPilotNavigator1.VisibleStart, DayPilotNavigator1.VisibleEnd, CStr(DayPilotMonth1.ClientState("filter")))
		DayPilotNavigator1.DataBind()
	End Sub

	Protected Sub DayPilotMonth1_Command(ByVal sender As Object, ByVal e As CommandEventArgs)

		Select Case e.Command
			Case "navigate"
				DayPilotMonth1.StartDate = CDate(e.Data("start"))
				DayPilotMonth1.DataSource = getData(DayPilotMonth1.VisibleStart, DayPilotMonth1.VisibleEnd, CStr(DayPilotMonth1.ClientState("filter")))
				DayPilotMonth1.DataBind()
				DayPilotMonth1.Update()
			Case "filter"
				DayPilotMonth1.DataSource = getData(DayPilotMonth1.VisibleStart, DayPilotMonth1.VisibleEnd, CStr(DayPilotMonth1.ClientState("filter")))
				DayPilotMonth1.DataBind()
				DayPilotMonth1.Update()
			Case "refresh"
				DayPilotMonth1.DataSource = getData(DayPilotMonth1.VisibleStart, DayPilotMonth1.VisibleEnd, CStr(DayPilotMonth1.ClientState("filter")))
				DayPilotMonth1.DataBind()
				DayPilotMonth1.UpdateWithMessage("Refreshed.")
		End Select

	End Sub

	''' <summary>
	''' This method should normally load the data from the database.
	''' We will load our copy from a Session, just simulating a database.
	''' </summary>
	''' <param name="start"></param>
	''' <param name="end"></param>
	''' <param name="filter"></param>
	''' <returns></returns>
	Private Function getData(ByVal start As Date, ByVal [end] As Date, ByVal filter As String) As DataTable
		Dim [select] As String
		If String.IsNullOrEmpty(filter) Then
			[select] = String.Format("NOT (([end] <= '{0:s}') OR ([start] >= '{1:s}'))", start, [end], filter)
		Else
			[select] = String.Format("NOT (([end] <= '{0:s}') OR ([start] >= '{1:s}')) and [name] like '%{2}%'", start, [end], filter)
'            throw new Exception(select);
		End If


		Dim rows() As DataRow = table.Select([select])

		Dim filtered As DataTable = table.Clone()

		For Each r As DataRow In rows
			filtered.ImportRow(r)
		Next r

		Return filtered
	End Function

	''' <summary>
	''' Make sure a copy of the data is in the Session so users can try changes on their own copy.
	''' </summary>
	Private Sub initData()
		If Session("MonthView") Is Nothing Then
			Session("MonthView") = DataGeneratorMonth.GetData()
		End If

		table = DirectCast(Session("MonthView"), DataTable)
	End Sub

	Protected Sub DayPilotMonth1_BeforeCellRender(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.Month.BeforeCellRenderEventArgs)
		e.CssClass = If(Week.WeekNrISO8601(e.Start) Mod 2 = 0, "even", "odd")
	End Sub

	Protected Sub DayPilotMonth1_EventClick(ByVal sender As Object, ByVal e As EventClickEventArgs)
	End Sub

End Class
