﻿Imports System
Imports System.Data
Imports System.Drawing
Imports System.Drawing.Imaging
Imports System.IO
Imports System.Text
Imports ASP.App_Code.Data
Imports DayPilot.Web.Ui.Enums
Imports DayPilot.Web.Ui.Events.Bubble
Imports DayPilot.Web.Ui.Events.Scheduler

Partial Public Class Scheduler_AutoRefresh
	Inherits System.Web.UI.Page

	Private table As DataTable

	Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
		initData()

		DayPilotScheduler1.StartDate = New Date(Date.Today.Year, Date.Today.Month, 1)
		DayPilotScheduler1.Days = Date.DaysInMonth(DayPilotScheduler1.StartDate.Year, DayPilotScheduler1.StartDate.Month) + Date.DaysInMonth(DayPilotScheduler1.StartDate.AddMonths(1).Year, DayPilotScheduler1.StartDate.AddMonths(1).Month)
		DayPilotScheduler1.Separators.Add(Date.Today, Color.Red)
		DayPilotScheduler1.CornerHtml = String.Format("<div style='padding:5px; font-weight: bold; font-size:22px; text-align:center'>{0}</div>", DayPilotScheduler1.StartDate.Year)

		If Not IsPostBack Then
			DayPilotScheduler1.SetScrollX(Date.Today)
			setDataSourceAndBind()
		End If
	End Sub

	Private Sub setDataSourceAndBind()
		' ensure that filter is loaded
		Dim filter As String = CStr(DayPilotScheduler1.ClientState("filter"))
		DayPilotScheduler1.DataSource = getData(DayPilotScheduler1.StartDate, DayPilotScheduler1.EndDate, filter)
		DayPilotScheduler1.DataBind()

	End Sub

	Protected Sub DayPilotScheduler1_EventMove(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.EventMoveEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			dr("column") = e.NewResource
			table.AcceptChanges()
		Else ' moved from outside
			dr = table.NewRow()
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			dr("id") = e.Id
			dr("name") = e.Text
			dr("column") = e.NewResource

			table.Rows.Add(dr)
			table.AcceptChanges()
		End If

'		#End Region

		setDataSourceAndBind()

		'Hashtable result = new Hashtable();
		'result["message"] = "Event moved";
		DayPilotScheduler1.UpdateWithMessage("Event moved")
	End Sub
	Protected Sub DayPilotScheduler1_EventResize(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.EventResizeEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			table.AcceptChanges()
		End If

'		#End Region

		setDataSourceAndBind()
		DayPilotScheduler1.Update()
	End Sub
	Protected Sub DayPilotScheduler1_TimeRangeSelected(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.TimeRangeSelectedEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.NewRow()
		dr("start") = e.Start
		dr("end") = e.End
		dr("id") = Guid.NewGuid().ToString()
		dr("name") = "New event"
		dr("column") = e.Resource

		table.Rows.Add(dr)
		table.AcceptChanges()
'		#End Region

		setDataSourceAndBind()
		DayPilotScheduler1.UpdateWithMessage("New event created.")
	End Sub
	Protected Sub DayPilotScheduler1_EventEdit(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.EventEditEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("name") = e.NewText
			table.AcceptChanges()
		End If

'		#End Region

		setDataSourceAndBind()
		DayPilotScheduler1.Update()
	End Sub

	Protected Sub DayPilotScheduler1_BeforeEventRender(ByVal sender As Object, ByVal e As BeforeEventRenderEventArgs)
	End Sub

	Protected Sub DayPilotScheduler1_EventMenuClick(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.EventMenuClickEventArgs)
		Select Case e.Command
			Case "Delete"
'				#Region "Simulation of database update"
				Dim dr As DataRow = table.Rows.Find(e.Id)

				If dr IsNot Nothing Then
					table.Rows.Remove(dr)
					table.AcceptChanges()
				End If
'				#End Region
		End Select

		setDataSourceAndBind()
		DayPilotScheduler1.Update()
	End Sub

	Protected Sub DayPilotScheduler1_BeforeResHeaderRender(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.Scheduler.BeforeResHeaderRenderEventArgs)
	End Sub

	Protected Sub DayPilotBubble1_RenderContent(ByVal sender As Object, ByVal e As RenderEventArgs)
		If TypeOf e Is RenderResourceBubbleEventArgs Then
			Dim re As RenderResourceBubbleEventArgs = TryCast(e, RenderResourceBubbleEventArgs)
			e.InnerHTML = "<b>Resource header details</b><br />Value: " & re.ResourceId
		ElseIf TypeOf e Is RenderCellBubbleEventArgs Then
			Dim re As RenderCellBubbleEventArgs = TryCast(e, RenderCellBubbleEventArgs)
			e.InnerHTML = "<b>Cell details</b><br />Resource:" & re.ResourceId & "<br />From:" & re.Start & "<br />To: " & re.End
		End If
	End Sub

	Protected Sub DayPilotScheduler1_Command(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.CommandEventArgs)
		Select Case e.Command
			Case "refresh"
				setDataSourceAndBind()
				DayPilotScheduler1.DataBind()
				DayPilotScheduler1.UpdateWithMessage("Events refreshed automatically")
			Case Else
				Throw New Exception("Unknown command.")

		End Select

		setDataSourceAndBind()
		DayPilotScheduler1.Update(CallBackUpdateType.Full)
	End Sub

	Protected Sub DayPilotScheduler1_EventClick(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.EventClickEventArgs)
		setDataSourceAndBind()
		DayPilotScheduler1.Update(String.Format("Event {0} clicked.", e.Id))
	End Sub

	Protected Sub DayPilotScheduler1_TimeRangeMenuClick(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.TimeRangeMenuClickEventArgs)
		If e.Command = "Insert" Then
'			#Region "Simulation of database update"

			Dim dr As DataRow = table.NewRow()
			dr("start") = e.Start
			dr("end") = e.End
			dr("id") = Guid.NewGuid().ToString()
			dr("name") = "New event"
			dr("column") = e.ResourceId

			table.Rows.Add(dr)
			table.AcceptChanges()
'			#End Region

			setDataSourceAndBind()
			DayPilotScheduler1.Update()
		End If
	End Sub


	''' <summary>
	''' Make sure a copy of the data is in the Session so users can try changes on their own copy.
	''' </summary>
	Private Sub initData()

		If Session(PageHash) Is Nothing Then
			Session(PageHash) = DataGeneratorScheduler.GetData()
		End If
		table = DirectCast(Session(PageHash), DataTable)
	End Sub

	Protected ReadOnly Property PageHash() As String
		Get
			Return Hash.ForPage(Me)
		End Get
	End Property

	''' <summary>
	''' This method should normally load the data from the database.
	''' We will load our copy from a Session, just simulating a database.
	''' </summary>
	''' <param name="start"></param>
	''' <param name="end"></param>
	''' <param name="filter"></param>
	''' <returns></returns>
	Private Function getData(ByVal start As Date, ByVal [end] As Date, ByVal filter As String) As DataTable
		Dim [select] As String
		If String.IsNullOrEmpty(filter) Then
			[select] = String.Format("NOT (([end] <= '{0:s}') OR ([start] >= '{1:s}'))", start, [end])
		Else
			[select] = String.Format("NOT (([end] <= '{0:s}') OR ([start] >= '{1:s}')) and [name] like '%{2}%'", start, [end], filter)
		End If
		'throw new Exception(select);

		Dim rows() As DataRow = table.Select([select])
		Dim filtered As DataTable = table.Clone()
		For Each r As DataRow In rows
			filtered.ImportRow(r)
		Next r
		Return filtered
	End Function

	Protected Sub DayPilotScheduler1_BeforeCellRender(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.BeforeCellRenderEventArgs)
'        
'        if (e.Start == new DateTime(2009, 6, 1))
'        {
'            e.BackgroundColor = "red";
'        }
	End Sub

	Protected Sub ButtonExport_Click(ByVal sender As Object, ByVal e As EventArgs)
		setDataSourceAndBind()

		Response.Clear()
		Response.ContentType = "image/png"
		Response.AddHeader("content-disposition", "attachment;filename=print.png")
		Dim img As MemoryStream = DayPilotScheduler1.Export(ImageFormat.Png)
		img.WriteTo(Response.OutputStream)
		Response.End()

	End Sub
	Protected Sub DayPilotScheduler1_Refresh(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.RefreshEventArgs)
		DayPilotScheduler1.StartDate = e.StartDate
		setDataSourceAndBind()
		DayPilotScheduler1.Update(CallBackUpdateType.Full)
	End Sub
	Protected Sub DayPilotBubble1_RenderEventBubble(ByVal sender As Object, ByVal e As RenderEventBubbleEventArgs)
		Dim sb As New StringBuilder()
		sb.AppendFormat("<b>{0}</b><br />", e.Text)
		sb.AppendFormat("Start: {0}<br />", e.Start)
		sb.AppendFormat("End: {0}<br />", e.End)

		e.InnerHTML = sb.ToString()

	End Sub
	Protected Sub DayPilotScheduler1_ResourceHeaderMenuClick(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.Scheduler.ResourceHeaderMenuClickEventArgs)
		Select Case e.Command
			Case "Insert"
				e.Resource.Children.Add("Testing Child", Guid.NewGuid().ToString())
				e.Resource.Expanded = True
			Case "DeleteChildren"
				e.Resource.Children.Clear()
			Case "Delete"
				DayPilotScheduler1.Resources.RemoveFromTree(e.Resource)
		End Select
		setDataSourceAndBind()
		DayPilotScheduler1.Update(CallBackUpdateType.Full)
	End Sub
	Protected Sub DayPilotScheduler1_ResourceHeaderClick(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.Scheduler.ResourceHeaderClickEventArgs)
		DayPilotScheduler1.Resources.RemoveFromTree(e.Resource)
		setDataSourceAndBind()
		DayPilotScheduler1.Update(CallBackUpdateType.Full)
	End Sub
End Class
