﻿Imports System
Imports System.Data
Imports System.Drawing
Imports ASP.App_Code.Data
Imports DayPilot.Web.Ui
Imports DayPilot.Web.Ui.Enums
Imports DayPilot.Web.Ui.Events
Imports DayPilot.Web.Ui.Events.Bubble
Imports DayPilot.Web.Ui.Events.Scheduler

Partial Public Class Scheduler_DynamicTreeLoading
	Inherits System.Web.UI.Page

	Private table As DataTable

	Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
		initData()
		preloadTree()
		If Not IsPostBack Then
			' set the month view
			DayPilotScheduler1.StartDate = New Date(Date.Today.Year, Date.Today.Month, 1)
			DayPilotScheduler1.Days = Date.DaysInMonth(Date.Today.Year, Date.Today.Month)
			'DayPilotScheduler1.Separators.Add(DateTime.Now, Color.Red);

			DayPilotScheduler1.SetScrollX(Date.Today)
			setDataSourceAndBind()
		End If
	End Sub

	Private Sub preloadTree()
		If DayPilotScheduler1.Resources.Count = 0 Then
			For i As Integer = 0 To 4
				Dim c As Char = ChrW(AscW("A"c) + i)
				Dim r As New Resource(c & "", c & "")
				r.DynamicChildren = True

				DayPilotScheduler1.Resources.Add(r)
			Next i
		End If
	End Sub

	Private Sub setDataSourceAndBind()
		' ensure that filter is loaded
		Dim filter As String = CStr(DayPilotScheduler1.ClientState("filter"))
		DayPilotScheduler1.DataSource = getData(DayPilotScheduler1.StartDate, DayPilotScheduler1.EndDate, filter)
		DayPilotScheduler1.DataBind()

	End Sub

	Protected Sub DayPilotScheduler1_EventMove(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.EventMoveEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			dr("column") = e.NewResource
			table.AcceptChanges()
		Else ' moved from outside
			dr = table.NewRow()
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			dr("id") = e.Id
			dr("name") = e.Text
			dr("column") = e.NewResource

			table.Rows.Add(dr)
			table.AcceptChanges()
		End If

'		#End Region

		setDataSourceAndBind()
		DayPilotScheduler1.Update("Event moved.")
	End Sub
	Protected Sub DayPilotScheduler1_EventResize(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.EventResizeEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			table.AcceptChanges()
		End If

'		#End Region

		setDataSourceAndBind()
		DayPilotScheduler1.Update()
	End Sub
	Protected Sub DayPilotScheduler1_TimeRangeSelected(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.TimeRangeSelectedEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.NewRow()
		dr("start") = e.Start
		dr("end") = e.End
		dr("id") = Guid.NewGuid().ToString()
		dr("name") = "New event"
		dr("column") = e.Resource

		table.Rows.Add(dr)
		table.AcceptChanges()
'		#End Region

		setDataSourceAndBind()
		DayPilotScheduler1.Update(String.Format("New event created."))
	End Sub
	Protected Sub DayPilotScheduler1_EventEdit(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.EventEditEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("name") = e.NewText
			table.AcceptChanges()
		End If

'		#End Region

		setDataSourceAndBind()
		DayPilotScheduler1.Update()
	End Sub

	Protected Sub DayPilotScheduler1_BeforeEventRender(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.Scheduler.BeforeEventRenderEventArgs)
		If e.Id = "11" Then
			e.ContextMenuClientName = "cmSpecial"
			e.EventMoveEnabled = False
			e.EventResizeEnabled = False
			e.EventClickEnabled = False
			e.DurationBarColor = "red"
			e.BackgroundColor = "lightyellow"
		End If
	End Sub

	Protected Sub DayPilotScheduler1_EventMenuClick(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.EventMenuClickEventArgs)
		Select Case e.Command
			Case "Delete"
'				#Region "Simulation of database update"
				Dim dr As DataRow = table.Rows.Find(e.Id)

				If dr IsNot Nothing Then
					table.Rows.Remove(dr)
					table.AcceptChanges()
				End If
'				#End Region
		End Select

		setDataSourceAndBind()
		DayPilotScheduler1.Update()
	End Sub

	Protected Sub DayPilotScheduler1_BeforeResHeaderRender(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.Scheduler.BeforeResHeaderRenderEventArgs)
	End Sub

	Protected Sub DayPilotBubble1_RenderContent(ByVal sender As Object, ByVal e As RenderEventArgs)
		If TypeOf e Is RenderEventBubbleEventArgs Then
			Dim re As RenderEventBubbleEventArgs = TryCast(e, RenderEventBubbleEventArgs)
			re.InnerHTML = "<b>Event details</b><br />Here is the right place to show details about the event with ID: " & re.Value & ". This text is loaded dynamically from the server."
		ElseIf TypeOf e Is RenderResourceBubbleEventArgs Then
			Dim re As RenderResourceBubbleEventArgs = TryCast(e, RenderResourceBubbleEventArgs)
			e.InnerHTML = "<b>Resource header details</b><br />Value: " & re.ResourceId
		ElseIf TypeOf e Is RenderCellBubbleEventArgs Then
			Dim re As RenderCellBubbleEventArgs = TryCast(e, RenderCellBubbleEventArgs)
			e.InnerHTML = "<b>Cell details</b><br />Resource:" & re.ResourceId & "<br />From:" & re.Start & "<br />To: " & re.End
		End If
	End Sub

	Protected Sub DayPilotScheduler1_Command(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.CommandEventArgs)
		Select Case e.Command
			Case "deletechildren"
				For Each resource As Resource In DayPilotScheduler1.Resources
					resource.Children.Clear()
					'resource.Children.Add("test", "test1");
					'resource.DynamicChildren = true;
					'resource.DynamicChildren = true;
					'resource.Expanded = true;
				Next resource
				DayPilotScheduler1.Update(CallBackUpdateType.Full)
		End Select
	End Sub

	Protected Sub DayPilotScheduler1_EventClick(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.EventClickEventArgs)
		setDataSourceAndBind()
		DayPilotScheduler1.Update(String.Format("Event {0} clicked.", e.Id))

	End Sub
	Protected Sub DayPilotScheduler1_TimeRangeMenuClick(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.TimeRangeMenuClickEventArgs)
		If e.Command = "Insert" Then
'			#Region "Simulation of database update"

			Dim dr As DataRow = table.NewRow()
			dr("start") = e.Start
			dr("end") = e.End
			dr("id") = Guid.NewGuid().ToString()
			dr("name") = "New event"
			dr("column") = e.ResourceId

			table.Rows.Add(dr)
			table.AcceptChanges()
'			#End Region

			setDataSourceAndBind()
			DayPilotScheduler1.Update()
		End If
	End Sub


	''' <summary>
	''' Make sure a copy of the data is in the Session so users can try changes on their own copy.
	''' </summary>
	Private Sub initData()

		If Session(PageHash) Is Nothing Then
			Session(PageHash) = DataGeneratorScheduler.GetData()
		End If
		table = DirectCast(Session(PageHash), DataTable)
	End Sub

	Protected ReadOnly Property PageHash() As String
		Get
			Return Hash.ForPage(Me)
		End Get
	End Property

	''' <summary>
	''' This method should normally load the data from the database.
	''' We will load our copy from a Session, just simulating a database.
	''' </summary>
	''' <param name="start"></param>
	''' <param name="end"></param>
	''' <param name="filter"></param>
	''' <returns></returns>
	Private Function getData(ByVal start As Date, ByVal [end] As Date, ByVal filter As String) As DataTable
		Dim [select] As String
		If String.IsNullOrEmpty(filter) Then
			[select] = String.Format("NOT (([end] <= '{0:s}') OR ([start] >= '{1:s}'))", start, [end])
		Else
			[select] = String.Format("NOT (([end] <= '{0:s}') OR ([start] >= '{1:s}')) and [name] like '%{2}%'", start, [end], filter)
		End If
		'throw new Exception(select);

		Dim rows() As DataRow = table.Select([select])
		Dim filtered As DataTable = table.Clone()
		For Each r As DataRow In rows
			filtered.ImportRow(r)
		Next r
		Return filtered
	End Function

	Protected Sub DayPilotScheduler1_BeforeCellRender(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.BeforeCellRenderEventArgs)
	End Sub

	Protected Sub DayPilotScheduler1_LoadNode(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.LoadNodeEventArgs)
		Dim r As Resource = e.Resource
		Dim child As New Resource("Test", Guid.NewGuid().ToString())
		child.DynamicChildren = True

		r.Children.Add(child)
		r.Expanded = True

		DayPilotScheduler1.DataSource = getData(DayPilotScheduler1.ViewPort.Start, DayPilotScheduler1.ViewPort.End, Nothing)
		DayPilotScheduler1.DataBind()

		DayPilotScheduler1.Update(CallBackUpdateType.Full)
	End Sub


	Protected Sub DayPilotScheduler1_OnResourceHeaderClick(ByVal sender As Object, ByVal e As ResourceHeaderClickEventArgs)
		'throw new Exception("resource clicked: " + e.Resource.Value);
	End Sub

	Protected Sub DayPilotScheduler1_Scroll(ByVal sender As Object, ByVal e As ScrollEventArgs)
		DayPilotScheduler1.DataSource = getData(DayPilotScheduler1.ViewPort.Start, DayPilotScheduler1.ViewPort.End, Nothing)
		DayPilotScheduler1.DataBind()
		DayPilotScheduler1.Update()
	End Sub
End Class
