﻿Imports System
Imports System.Data
Imports System.Drawing
Imports System.Drawing.Imaging
Imports System.IO
Imports System.Text
Imports System.Web.UI.WebControls
Imports ASP.App_Code.Data
Imports DayPilot.Json
Imports DayPilot.Utils
Imports DayPilot.Web.Ui
Imports DayPilot.Web.Ui.Enums
Imports DayPilot.Web.Ui.Enums.Scheduler
Imports DayPilot.Web.Ui.Events
Imports DayPilot.Web.Ui.Events.Bubble
Imports DayPilot.Web.Ui.Events.Common
Imports DayPilot.Web.Ui.Events.Scheduler

Partial Public Class Scheduler_MultiRangeSelecting
	Inherits System.Web.UI.Page

	Private table As DataTable

	Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
		initData()

		DayPilotScheduler1.StartDate = New Date(Date.Today.Year, 1, 1)
		DayPilotScheduler1.Days = Year.Days(Date.Today.Year)
		DayPilotScheduler1.Separators.Add(Date.Today, Color.Red)

		DayPilotScheduler1.MultiSelectRectangle = MultiSelectRectangleType.Free

		If Not IsPostBack Then
			DayPilotScheduler1.SetScrollX(Date.Today)
			'DayPilotScheduler1.ScrollY = 10;
			setDataSourceAndBind()
		End If
	End Sub

	Private Sub setDataSourceAndBind()
		' ensure that filter is loaded
		Dim filter As String = CStr(DayPilotScheduler1.ClientState("filter"))
		DayPilotScheduler1.DataSource = getData(DayPilotScheduler1.StartDate, DayPilotScheduler1.EndDate, filter)
		DayPilotScheduler1.DataBind()
	End Sub

	Protected Sub DayPilotScheduler1_EventMove(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.EventMoveEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			dr("column") = e.NewResource
			table.AcceptChanges()
		Else ' moved from outside
			dr = table.NewRow()
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			dr("id") = e.Id
			dr("name") = e.Text
			dr("column") = e.NewResource

			table.Rows.Add(dr)
			table.AcceptChanges()
		End If

'		#End Region

		setDataSourceAndBind()

		'DayPilotScheduler1.ScrollX = 2900;
		DayPilotScheduler1.UpdateWithMessage("Event moved.")
	End Sub
	Protected Sub DayPilotScheduler1_EventResize(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.EventResizeEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			table.AcceptChanges()
		End If

'		#End Region

		setDataSourceAndBind()
		DayPilotScheduler1.Update()
	End Sub
	Protected Sub DayPilotScheduler1_TimeRangeSelected(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.TimeRangeSelectedEventArgs)
'		#Region "Simulation of database update"

		If e.Multirange IsNot Nothing Then
			For Each [me] As TimeRangeSelectedEventArgs In e.Multirange
				CreateEvent([me].Start, [me].End, [me].Resource)
			Next [me]
		Else
			CreateEvent(e.Start, e.End, e.Resource)

		End If

'		#End Region

		setDataSourceAndBind()
		DayPilotScheduler1.UpdateWithMessage("New event created.")
	End Sub

	Private Sub CreateEvent(ByVal start As Date, ByVal [end] As Date, ByVal resource As String)
		Dim dr As DataRow = table.NewRow()
		dr("start") = start
		dr("end") = [end]
		dr("id") = Guid.NewGuid().ToString()
		dr("name") = "New event"
		dr("column") = resource

		table.Rows.Add(dr)
		table.AcceptChanges()
	End Sub


	Protected Sub DayPilotScheduler1_EventEdit(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.EventEditEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("name") = e.NewText
			table.AcceptChanges()
		End If

'		#End Region

		setDataSourceAndBind()
		DayPilotScheduler1.Update()
	End Sub

	Protected Sub DayPilotScheduler1_BeforeEventRender(ByVal sender As Object, ByVal e As BeforeEventRenderEventArgs)
	End Sub

	Protected Sub DayPilotScheduler1_EventMenuClick(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.EventMenuClickEventArgs)
		Select Case e.Command
			Case "Delete"
'				#Region "Simulation of database update"
				Dim dr As DataRow = table.Rows.Find(e.Id)

				If dr IsNot Nothing Then
					table.Rows.Remove(dr)
					table.AcceptChanges()
				End If
'				#End Region
		End Select

		setDataSourceAndBind()
		DayPilotScheduler1.Update()
	End Sub

	Protected Sub DayPilotScheduler1_BeforeResHeaderRender(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.Scheduler.BeforeResHeaderRenderEventArgs)
	End Sub

	Protected Sub DayPilotBubble1_RenderContent(ByVal sender As Object, ByVal e As RenderEventArgs)
		If TypeOf e Is RenderResourceBubbleEventArgs Then
			Dim re As RenderResourceBubbleEventArgs = TryCast(e, RenderResourceBubbleEventArgs)
			e.InnerHTML = "<b>Resource header details</b><br />Value: " & re.ResourceId
		ElseIf TypeOf e Is RenderCellBubbleEventArgs Then
			Dim re As RenderCellBubbleEventArgs = TryCast(e, RenderCellBubbleEventArgs)
			e.InnerHTML = "<b>Cell details</b><br />Resource:" & re.ResourceId & "<br />From:" & re.Start & "<br />To: " & re.End
		End If
	End Sub

	Protected Sub DayPilotScheduler1_Command(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.CommandEventArgs)
		Select Case e.Command
			Case "next"
				DayPilotScheduler1.StartDate = DayPilotScheduler1.StartDate.AddYears(1)
				DayPilotScheduler1.Days = Year.Days(DayPilotScheduler1.StartDate.Year)
				DayPilotScheduler1.ScrollY = 20
			Case "previous"
				DayPilotScheduler1.StartDate = DayPilotScheduler1.StartDate.AddYears(-1)
				DayPilotScheduler1.Days = Year.Days(DayPilotScheduler1.StartDate.Year)
			Case "this"
				DayPilotScheduler1.StartDate = New Date(Date.Today.Year, 1, 1)
				DayPilotScheduler1.Days = Year.Days(DayPilotScheduler1.StartDate.Year)
			Case "test"
				Dim d As JsonData = e.Data
			Case "selected"
				If DayPilotScheduler1.SelectedEvents.Count > 0 Then
					Dim ei As EventInfo = DayPilotScheduler1.SelectedEvents(0)
					DayPilotScheduler1.SelectedEvents.RemoveAt(0)
					'DayPilotScheduler1.DataBind();
					DayPilotScheduler1.UpdateWithMessage("Event removed from selection: " & ei.Text)
				End If

			Case "refresh"
				' refresh is always done, see setDataSourceAndBind()
			Case "filter"
				' refresh is always done, see setDataSourceAndBind()
			Case Else
				Throw New Exception("Unknown command.")

		End Select

		setDataSourceAndBind()
		DayPilotScheduler1.Update()
	End Sub

	Protected Sub DayPilotScheduler1_EventClick(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.EventClickEventArgs)
		setDataSourceAndBind()
		DayPilotScheduler1.UpdateWithMessage(String.Format("Event {0} clicked.", e.Id))
		'throw new Exception("ScrollX: " + DayPilotScheduler1.ScrollX);
	End Sub

	Protected Sub DayPilotScheduler1_TimeRangeMenuClick(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.TimeRangeMenuClickEventArgs)
		If e.Command = "Insert" Then
'			#Region "Simulation of database update"

			Dim dr As DataRow = table.NewRow()
			dr("start") = e.Start
			dr("end") = e.End
			dr("id") = Guid.NewGuid().ToString()
			dr("name") = "New event"
			dr("column") = e.ResourceId

			table.Rows.Add(dr)
			table.AcceptChanges()
'			#End Region

			setDataSourceAndBind()
			DayPilotScheduler1.Update()
		End If
	End Sub


	''' <summary>
	''' Make sure a copy of the data is in the Session so users can try changes on their own copy.
	''' </summary>
	Private Sub initData()

		If Session(PageHash) Is Nothing Then
			Session(PageHash) = DataGeneratorScheduler.GetData()
		End If
		table = DirectCast(Session(PageHash), DataTable)
	End Sub

	Protected ReadOnly Property PageHash() As String
		Get
			Return Hash.ForPage(Me)
		End Get
	End Property


	''' <summary>
	''' This method should normally load the data from the database.
	''' We will load our copy from a Session, just simulating a database.
	''' </summary>
	''' <param name="start"></param>
	''' <param name="end"></param>
	''' <param name="filter"></param>
	''' <returns></returns>
	Private Function getData(ByVal start As Date, ByVal [end] As Date, ByVal filter As String) As DataTable
		Dim [select] As String
		If String.IsNullOrEmpty(filter) Then
			[select] = String.Format("NOT (([end] <= '{0:s}') OR ([start] >= '{1:s}'))", start, [end])
		Else
			[select] = String.Format("NOT (([end] <= '{0:s}') OR ([start] >= '{1:s}')) and [name] like '%{2}%'", start, [end], filter)
		End If
		'throw new Exception(select);

		Dim rows() As DataRow = table.Select([select])
		Dim filtered As DataTable = table.Clone()
		For Each r As DataRow In rows
			filtered.ImportRow(r)
		Next r
		Return filtered
	End Function

	Protected Sub DayPilotScheduler1_BeforeCellRender(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.BeforeCellRenderEventArgs)
	End Sub

	Protected Sub DayPilotScheduler1_Refresh(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.RefreshEventArgs)
		DayPilotScheduler1.StartDate = e.StartDate
		setDataSourceAndBind()
		DayPilotScheduler1.Update(CallBackUpdateType.Full)
	End Sub

	Protected Sub DayPilotBubble1_RenderEventBubble(ByVal sender As Object, ByVal e As RenderEventBubbleEventArgs)
		Dim sb As New StringBuilder()
		sb.AppendFormat("<b>{0}</b><br />", e.Text)
		sb.AppendFormat("Start: {0}<br />", e.Start)
		sb.AppendFormat("End: {0}<br />", e.End)

		e.InnerHTML = sb.ToString()

	End Sub
	Protected Sub DayPilotScheduler1_ResourceHeaderMenuClick(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.Scheduler.ResourceHeaderMenuClickEventArgs)
		Select Case e.Command
			Case "Insert"
				e.Resource.Children.Add("Testing Child", Guid.NewGuid().ToString())
				e.Resource.Expanded = True
			Case "DeleteChildren"
				e.Resource.Children.Clear()
			Case "Delete"
				DayPilotScheduler1.Resources.RemoveFromTree(e.Resource)
		End Select
		setDataSourceAndBind()
		DayPilotScheduler1.Update()
	End Sub
	Protected Sub DayPilotScheduler1_ResourceHeaderClick(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.Scheduler.ResourceHeaderClickEventArgs)
		DayPilotScheduler1.Resources.RemoveFromTree(e.Resource)
		setDataSourceAndBind()
		DayPilotScheduler1.Update()
	End Sub
	Protected Sub DayPilotScheduler1_BeforeTimeHeaderRender(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.BeforeTimeHeaderRenderEventArgs)

	End Sub

	Protected Sub DayPilotScheduler1_Notify(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.Scheduler.NotifyEventArgs)
		For Each ea As DayPilotEventArgs In e.Queue
			If TypeOf ea Is EventMoveEventArgs Then
				Dim em As EventMoveEventArgs = CType(ea, EventMoveEventArgs)

'				#Region "Simulation of database update"

				Dim dr As DataRow = table.Rows.Find(em.Id)
				If dr IsNot Nothing Then
					dr("start") = em.NewStart
					dr("end") = em.NewEnd
					dr("column") = em.NewResource
					table.AcceptChanges()
				Else
					Throw New Exception("Event id not found.")
				End If
'				#End Region
			ElseIf TypeOf ea Is EventUpdateEventArgs Then
				DayPilotScheduler1_EventUpdate(sender, CType(ea, EventUpdateEventArgs))
			End If
		Next ea
	End Sub
	Protected Sub DayPilotScheduler1_EventUpdate(ByVal sender As Object, ByVal e As EventUpdateEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Event.Value)
		If dr IsNot Nothing Then
			dr("start") = e.[New].Start
			dr("end") = e.[New].End
			dr("column") = e.[New].Resource
			dr("name") = e.[New].Text
			table.AcceptChanges()
		Else
			Throw New Exception("Event id not found.")
		End If
'		#End Region


	End Sub

	Protected Sub DayPilotScheduler1_OnEventRightClick(ByVal sender As Object, ByVal e As EventRightClickEventArgs)

	End Sub

End Class
