﻿' Copyright � 2005 - 2011 Annpoint, s.r.o.
'   Use of this software is subject to license terms. 
'   http://www.daypilot.org/
'
'   If you have purchased a DayPilot Pro license, you are allowed to use this 
'   code under the conditions of DayPilot Pro License Agreement:
'
'   http://www.daypilot.org/files/LicenseAgreement.pdf
'
'   Otherwise, you are allowed to use it for evaluation purposes only under 
'   the conditions of DayPilot Pro Trial License Agreement:
'   
'   http://www.daypilot.org/files/LicenseAgreementTrial.pdf
'   
'

Imports System
Imports System.Data
Imports System.Web.UI

Partial Public Class [New]
	Inherits Page

	Private table As DataTable

	Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
		If Not IsPostBack Then
			Dim time As Boolean = Request.QueryString("time") = "yes"

			If time Then
				TextBoxStart.Text = Convert.ToDateTime(Request.QueryString("start")).ToString()
				TextBoxEnd.Text = Convert.ToDateTime(Request.QueryString("end")).ToString()
			Else
				TextBoxStart.Text = Convert.ToDateTime(Request.QueryString("start")).ToShortDateString()
				TextBoxEnd.Text = Convert.ToDateTime(Request.QueryString("end")).ToShortDateString()
			End If

			'TextBoxName.Focus();

			DropDownList1.SelectedValue = Request.QueryString("r")
		End If
	End Sub
	Protected Sub ButtonOK_Click(ByVal sender As Object, ByVal e As EventArgs)
		Dim start As Date = Convert.ToDateTime(TextBoxStart.Text)
		Dim [end] As Date = Convert.ToDateTime(TextBoxEnd.Text)
		Dim name As String = TextBoxName.Text
		Dim resource As String = DropDownList1.SelectedValue

		dbInsertEvent(start, [end], name, resource)
		Modal.Close(Me, "OK")
	End Sub

	Private Function dbInsertEvent(ByVal start As Date, ByVal [end] As Date, ByVal name As String, ByVal resource As String) As String
		initData()

'NOTE: The variable id was renamed since Visual Basic does not handle local variables named the same as class members well:
		Dim id_Renamed As String = Guid.NewGuid().ToString()

'		#Region "Simulation of database update"

		Dim dr As DataRow = table.NewRow()
		dr("start") = start
		dr("end") = [end]
		dr("id") = id_Renamed
		dr("name") = name
		dr("column") = resource

		table.Rows.Add(dr)
		table.AcceptChanges()
'		#End Region

		Return id_Renamed
	End Function

	Protected Sub ButtonCancel_Click(ByVal sender As Object, ByVal e As EventArgs)
		Modal.Close(Me)
	End Sub

	Private Sub initData()
'NOTE: The variable id was renamed since Visual Basic does not handle local variables named the same as class members well:
		Dim id_Renamed As String = Request.QueryString("hash")

		If Session(id_Renamed) Is Nothing Then
			Session(id_Renamed) = DataGeneratorScheduler.GetData()
		End If
		table = DirectCast(Session(id_Renamed), DataTable)
	End Sub

	Protected Sub DropDownList1_OnSelectedIndexChanged(ByVal sender As Object, ByVal e As EventArgs)
		TextBoxName.Text = DropDownList1.SelectedValue
	End Sub
End Class
