﻿Imports System
Imports System.Data
Imports DayPilot.Web.Ui.Recurrence

Partial Public Class Scheduler_RecurrentEventEdit
	Inherits System.Web.UI.Page

	Private table As DataTable
	Private _rule As RecurrenceRule = RecurrenceRule.NoRepeat



	Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
		Response.Cache.SetNoStore()

		Dim data As String = Request.QueryString("hash")
		If Session(data) Is Nothing Then
			Throw New Exception("The session data expired.")
		End If
		table = DirectCast(Session(data), DataTable)

		Dim row As DataRow = table.Rows.Find(Request.QueryString("id"))
'NOTE: The variable master was renamed since Visual Basic does not handle local variables named the same as class members well:
		Dim master_Renamed As DataRow = table.Rows.Find(Request.QueryString("master"))

		If Not IsPostBack Then
			Select Case Mode
				Case EventMode.Master
					_rule = RecurrenceRule.Decode(DirectCast(master_Renamed("recurrence"), String))
					TextBoxStart.Text = DirectCast(master_Renamed("start"), Date).ToString()
					TextBoxEnd.Text = DirectCast(master_Renamed("end"), Date).ToString()
					TextBoxName.Text = DirectCast(master_Renamed("name"), String)
				Case EventMode.NewException
					_rule = RecurrenceRule.Exception
					Dim start As Date = Occurrence
					Dim duration As TimeSpan = DirectCast(master_Renamed("end"), Date) - DirectCast(master_Renamed("start"), Date)
					Dim [end] As Date = start.Add(duration)
					TextBoxStart.Text = start.ToString()
					TextBoxEnd.Text = [end].ToString()
					TextBoxName.Text = DirectCast(master_Renamed("name"), String)
				Case EventMode.Exception
					_rule = RecurrenceRule.Exception
					TextBoxStart.Text = DirectCast(row("start"), Date).ToString()
					TextBoxEnd.Text = DirectCast(row("end"), Date).ToString()
					TextBoxName.Text = DirectCast(row("name"), String)
				Case EventMode.Regular
					_rule = RecurrenceRule.NoRepeat
					TextBoxStart.Text = DirectCast(row("start"), Date).ToString()
					TextBoxEnd.Text = DirectCast(row("end"), Date).ToString()
					TextBoxName.Text = DirectCast(row("name"), String)
				Case Else
					Throw New ArgumentOutOfRangeException()
			End Select
		End If
	End Sub

	Private ReadOnly Property Mode() As EventMode
		Get
			If Not String.IsNullOrEmpty(Request.QueryString("master")) Then
				If Not String.IsNullOrEmpty(Request.QueryString("start")) Then
					Return EventMode.NewException
				End If
				If Not String.IsNullOrEmpty(Request.QueryString("id")) Then
					Return EventMode.Exception
				End If
				Return EventMode.Master
			End If

			Return EventMode.Regular
		End Get

	End Property

	Private Enum EventMode
		Master
		NewException
		Exception
		Regular
	End Enum

	Private ReadOnly Property Occurrence() As Date
		Get
			Return Convert.ToDateTime(Request.QueryString("start"))
		End Get
	End Property

	Protected ReadOnly Property RecurrenceJson() As String
		Get
			Return _rule.ToJson()
		End Get
	End Property
	Protected Sub ButtonSave_Click(ByVal sender As Object, ByVal e As EventArgs)
'NOTE: The variable id was renamed since Visual Basic does not handle local variables named the same as class members well:
		Dim id_Renamed As String = Request.QueryString("id")
		Dim masterId As String = Request.QueryString("master")

'NOTE: The variable master was renamed since Visual Basic does not handle local variables named the same as class members well:
		Dim master_Renamed As DataRow = table.Rows.Find(masterId)
		Dim row As DataRow = table.Rows.Find(id_Renamed)

		Select Case Mode
			Case EventMode.Master
				Dim rule As RecurrenceRule = RecurrenceRule.FromJson(masterId, DirectCast(master_Renamed("start"), Date), Recurrence.Value)
				master_Renamed("name") = TextBoxName.Text
				master_Renamed("start") = Convert.ToDateTime(TextBoxStart.Text)
				master_Renamed("end") = Convert.ToDateTime(TextBoxEnd.Text)
				master_Renamed("recurrence") = rule.Encode()
				table.AcceptChanges()
			Case EventMode.NewException
				Dim r As DataRow = table.NewRow()
				r("id") = Guid.NewGuid().ToString()
				r("name") = TextBoxName.Text
				r("start") = Convert.ToDateTime(TextBoxStart.Text)
				r("end") = Convert.ToDateTime(TextBoxEnd.Text)
				r("recurrence") = RecurrenceRule.EncodeExceptionModified(masterId, Occurrence)
				table.Rows.Add(r)
				table.AcceptChanges()
			Case EventMode.Exception
				row("name") = TextBoxName.Text
				row("start") = Convert.ToDateTime(TextBoxStart.Text)
				row("end") = Convert.ToDateTime(TextBoxEnd.Text)
				table.AcceptChanges()
			Case EventMode.Regular
				row("name") = TextBoxName.Text
				row("start") = Convert.ToDateTime(TextBoxStart.Text)
				row("end") = Convert.ToDateTime(TextBoxEnd.Text)
				row("recurrence") = RecurrenceRule.FromJson(id_Renamed, DirectCast(row("start"), Date), Recurrence.Value).Encode()
				table.AcceptChanges()
			Case Else
				Throw New ArgumentOutOfRangeException()
		End Select

		Modal.Close(Me, "OK")
	End Sub
	Protected Sub ButtonCancel_Click(ByVal sender As Object, ByVal e As EventArgs)
		Modal.Close(Me)
	End Sub
End Class
