﻿Imports System
Imports System.Data
Imports System.Drawing
Imports System.Text
Imports ASP.App_Code.Data
Imports DayPilot.Utils
Imports DayPilot.Web.Ui.Enums
Imports DayPilot.Web.Ui.Events.Bubble
Imports DayPilot.Web.Ui.Events.Scheduler
Imports DayPilot.Web.Ui.Recurrence

Partial Public Class Scheduler_RecurrentEvents
	Inherits System.Web.UI.Page

	Private table As DataTable

	Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
		initData()

		DayPilotScheduler1.StartDate = New Date(Date.Today.Year, 1, 1)
		DayPilotScheduler1.Days = Year.Days(Date.Today.Year)
		DayPilotScheduler1.Separators.Add(Date.Today, Color.Red)

		If Not IsPostBack Then
			DayPilotScheduler1.SetScrollX(Date.Today)
			'DayPilotScheduler1.ScrollY = 10;
			setDataSourceAndBind()
		End If
	End Sub

	Private Sub setDataSourceAndBind()
		' ensure that filter is loaded
		Dim filter As String = CStr(DayPilotScheduler1.ClientState("filter"))
		DayPilotScheduler1.DataSource = getData(DayPilotScheduler1.StartDate, DayPilotScheduler1.EndDate, filter)
		DayPilotScheduler1.DataBind()
	End Sub

	Protected Sub DayPilotScheduler1_EventMove(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.EventMoveEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			dr("column") = e.NewResource
			table.AcceptChanges()
		Else ' moved from outside
			dr = table.NewRow()
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			dr("id") = e.Id
			dr("name") = e.Text
			dr("column") = e.NewResource

			table.Rows.Add(dr)
			table.AcceptChanges()
		End If

'		#End Region

		setDataSourceAndBind()

		DayPilotScheduler1.UpdateWithMessage("Event moved")
	End Sub
	Protected Sub DayPilotScheduler1_EventResize(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.EventResizeEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			table.AcceptChanges()
		End If

'		#End Region

		setDataSourceAndBind()
		DayPilotScheduler1.Update()
	End Sub
	Protected Sub DayPilotScheduler1_TimeRangeSelected(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.TimeRangeSelectedEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.NewRow()
		dr("start") = e.Start
		dr("end") = e.End
		dr("id") = Guid.NewGuid().ToString()
		dr("name") = "New event"
		dr("column") = e.Resource

		table.Rows.Add(dr)
		table.AcceptChanges()
'		#End Region

		setDataSourceAndBind()
		DayPilotScheduler1.UpdateWithMessage("New event created.")
	End Sub
	Protected Sub DayPilotScheduler1_EventEdit(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.EventEditEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("name") = e.NewText
			table.AcceptChanges()
		End If

'		#End Region

		setDataSourceAndBind()
		DayPilotScheduler1.Update()
	End Sub

	Protected Sub DayPilotScheduler1_BeforeEventRender(ByVal sender As Object, ByVal e As BeforeEventRenderEventArgs)
	End Sub

	Protected Sub DayPilotScheduler1_EventMenuClick(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.EventMenuClickEventArgs)
		Select Case e.Command
			Case "Delete"
'				#Region "Simulation of database update"
				Dim dr As DataRow = table.Rows.Find(e.Id)

				If dr IsNot Nothing Then
					table.Rows.Remove(dr)
					table.AcceptChanges()
				End If
'				#End Region
		End Select

		setDataSourceAndBind()
		DayPilotScheduler1.Update()
	End Sub

	Protected Sub DayPilotScheduler1_BeforeResHeaderRender(ByVal sender As Object, ByVal e As BeforeResHeaderRenderEventArgs)
	End Sub

	Protected Sub DayPilotBubble1_RenderContent(ByVal sender As Object, ByVal e As RenderEventArgs)
		If TypeOf e Is RenderResourceBubbleEventArgs Then
			Dim re As RenderResourceBubbleEventArgs = TryCast(e, RenderResourceBubbleEventArgs)
			e.InnerHTML = "<b>Resource header details</b><br />Value: " & re.ResourceId
		ElseIf TypeOf e Is RenderCellBubbleEventArgs Then
			Dim re As RenderCellBubbleEventArgs = TryCast(e, RenderCellBubbleEventArgs)
			e.InnerHTML = "<b>Cell details</b><br />Resource:" & re.ResourceId & "<br />From:" & re.Start & "<br />To: " & re.End
		End If
	End Sub

	Protected Sub DayPilotScheduler1_Command(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.CommandEventArgs)
		Select Case e.Command
			Case "next"
				DayPilotScheduler1.StartDate = DayPilotScheduler1.StartDate.AddYears(1)
				DayPilotScheduler1.Days = Year.Days(DayPilotScheduler1.StartDate.Year)
				DayPilotScheduler1.ScrollY = 20
			Case "previous"
				DayPilotScheduler1.StartDate = DayPilotScheduler1.StartDate.AddYears(-1)
				DayPilotScheduler1.Days = Year.Days(DayPilotScheduler1.StartDate.Year)
			Case "this"
				DayPilotScheduler1.StartDate = New Date(Date.Today.Year, 1, 1)
				DayPilotScheduler1.Days = Year.Days(DayPilotScheduler1.StartDate.Year)
			Case "refresh", "filter"
				' refresh is always done, see setDataSourceAndBind()
			Case Else
				Throw New Exception("Unknown command.")

		End Select

		setDataSourceAndBind()
		DayPilotScheduler1.Update()
	End Sub

	Protected Sub DayPilotScheduler1_EventClick(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.EventClickEventArgs)
		setDataSourceAndBind()
		DayPilotScheduler1.UpdateWithMessage(String.Format("Event {0} clicked.", e.Id))
		'throw new Exception("ScrollX: " + DayPilotScheduler1.ScrollX);
	End Sub

	Protected Sub DayPilotScheduler1_TimeRangeMenuClick(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.TimeRangeMenuClickEventArgs)
		If e.Command = "Insert" Then
'			#Region "Simulation of database update"

			Dim dr As DataRow = table.NewRow()
			dr("start") = e.Start
			dr("end") = e.End
			dr("id") = Guid.NewGuid().ToString()
			dr("name") = "New event"
			dr("column") = e.ResourceId

			table.Rows.Add(dr)
			table.AcceptChanges()
'			#End Region

			setDataSourceAndBind()
			DayPilotScheduler1.Update()
		End If
	End Sub


	''' <summary>
	''' Make sure a copy of the data is in the Session so users can try changes on their own copy.
	''' </summary>
	Private Sub initData()

		If Session(PageHash) Is Nothing Then
			Session(PageHash) = GetData_Renamed()
		End If
		table = DirectCast(Session(PageHash), DataTable)
	End Sub

	Protected ReadOnly Property PageHash() As String
		Get
			Return Hash.ForPage(Me)
		End Get
	End Property

	''' <summary>
	''' This method should normally load the data from the database.
	''' We will load our copy from a Session, just simulating a database.
	''' </summary>
	''' <param name="start"></param>
	''' <param name="end"></param>
	''' <param name="filter"></param>
	''' <returns></returns>
	Private Function getData(ByVal start As Date, ByVal [end] As Date, ByVal filter As String) As DataTable
		Dim [select] As String
		If String.IsNullOrEmpty(filter) Then
			[select] = String.Format("NOT (([end] <= '{0:s}') OR ([start] >= '{1:s}'))", start, [end])
		Else
			[select] = String.Format("NOT (([end] <= '{0:s}') OR ([start] >= '{1:s}')) and [name] like '%{2}%'", start, [end], filter)
		End If
		'throw new Exception(select);

		Dim rows() As DataRow = table.Select([select])
		Dim filtered As DataTable = table.Clone()
		For Each r As DataRow In rows
			filtered.ImportRow(r)
		Next r
		Return filtered
	End Function

	Protected Sub DayPilotScheduler1_BeforeCellRender(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.BeforeCellRenderEventArgs)
	End Sub

	Protected Sub DayPilotScheduler1_Refresh(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.RefreshEventArgs)
		DayPilotScheduler1.StartDate = e.StartDate
		setDataSourceAndBind()
		DayPilotScheduler1.Update(CallBackUpdateType.Full)
	End Sub

	Protected Sub DayPilotBubble1_RenderEventBubble(ByVal sender As Object, ByVal e As RenderEventBubbleEventArgs)
		Dim sb As New StringBuilder()
		sb.AppendFormat("<b>{0}</b><br />", e.Text)
		sb.AppendFormat("Start: {0}<br />", e.Start)
		sb.AppendFormat("End: {0}<br />", e.End)

		e.InnerHTML = sb.ToString()

	End Sub
	Protected Sub DayPilotScheduler1_ResourceHeaderMenuClick(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.Scheduler.ResourceHeaderMenuClickEventArgs)
		Select Case e.Command
			Case "Insert"
				e.Resource.Children.Add("Testing Child", Guid.NewGuid().ToString())
				e.Resource.Expanded = True
			Case "DeleteChildren"
				e.Resource.Children.Clear()
			Case "Delete"
				DayPilotScheduler1.Resources.RemoveFromTree(e.Resource)
		End Select
		setDataSourceAndBind()
		DayPilotScheduler1.Update()
	End Sub
	Protected Sub DayPilotScheduler1_ResourceHeaderClick(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.Scheduler.ResourceHeaderClickEventArgs)
		DayPilotScheduler1.Resources.RemoveFromTree(e.Resource)
		setDataSourceAndBind()
		DayPilotScheduler1.Update()
	End Sub
	Protected Sub DayPilotScheduler1_BeforeTimeHeaderRender(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.BeforeTimeHeaderRenderEventArgs)
	End Sub

'NOTE: The method GetData was renamed since Visual Basic does not allow same-signature methods with the same name:
	Private Function GetData_Renamed() As DataTable

		Dim dt As DataTable
		dt = New DataTable()
		dt.Columns.Add("start", GetType(Date))
		dt.Columns.Add("end", GetType(Date))
		dt.Columns.Add("name", GetType(String))
		dt.Columns.Add("id", GetType(String))
		dt.Columns.Add("column", GetType(String))
		dt.Columns.Add("recurrence", GetType(String))

		Dim dr As DataRow

		Dim start As Date = Week.FirstDayOfWeek().AddHours(15)
		' starting on the first day of this week today at 15:00, repeated every week, five times
		Dim rule As RecurrenceRule = RecurrenceRule.FromDateTime("1", start).Weekly().Times(5)

		dr = dt.NewRow()
		dr("id") = 1
		dr("start") = start
		dr("end") = start.AddHours(1)
		dr("name") = "Every week"
		dr("column") = "A"
		dr("recurrence") = rule.Encode()
		dt.Rows.Add(dr)

		Dim start2 As Date = Week.FirstDayOfWeek().AddHours(10)
		' starting on the first day of this week at 10:00, repeated every day for one month

		Dim rule2 As RecurrenceRule = RecurrenceRule.FromDateTime((2).ToString(), start2).Daily()

		dr = dt.NewRow()
		dr("id") = 2
		dr("start") = start2
		dr("end") = start2.AddHours(1)
		dr("name") = "Every day"
		dr("recurrence") = rule2.Encode()
		dr("column") = "B"
		dt.Rows.Add(dr)

		dt.PrimaryKey = New DataColumn() { dt.Columns("id") }

		Return dt
	End Function

End Class
