﻿Imports System
Imports System.Data
Imports System.Drawing.Imaging
Imports System.IO
Imports System.Web.UI.WebControls
Imports DayPilot.Web.Ui.Events
Imports DayPilot.Web.Ui.Events.Scheduler


Partial Public Class Timesheet
	Inherits System.Web.UI.Page

	Private table As DataTable

	Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
'		#Region "Data loading initialization"
		If Session("DaysModeMonth") Is Nothing Then
			Session("DaysModeMonth") = DataGeneratorScheduler.GetDataDays()
		End If
		table = DirectCast(Session("DaysModeMonth"), DataTable)
		DayPilotScheduler1.DataSource = Session("DaysModeMonth")
'		#End Region

		If Not IsPostBack Then
			Dim start As New Date(Date.Today.Year, Date.Today.Month, 1)
			Dim [end] As Date = start.AddMonths(1)
			Dim days As Integer = CInt(Math.Truncate(Math.Floor(([end].Subtract(start)).TotalDays)))

			DayPilotScheduler1.StartDate = start
			DayPilotScheduler1.Days = days

			DayPilotScheduler1.SetScrollX(DayPilotScheduler1.StartDate.Date.AddHours(8))

			DataBind()
		End If

	End Sub
	Protected Sub DayPilotScheduler1_EventResize(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.EventResizeEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			table.AcceptChanges()
		End If

'		#End Region

		DayPilotScheduler1.DataBind()
		DayPilotScheduler1.Update()
	End Sub
	Protected Sub DayPilotScheduler1_EventMove(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.EventMoveEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.Rows.Find(e.Id)
		If dr IsNot Nothing Then
			dr("start") = e.NewStart
			dr("end") = e.NewEnd
			dr("column") = e.NewResource
			table.AcceptChanges()
		End If

'		#End Region

		DayPilotScheduler1.DataBind()
		DayPilotScheduler1.Update()

	End Sub
	Protected Sub DayPilotScheduler1_TimeRangeSelected(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.TimeRangeSelectedEventArgs)
'		#Region "Simulation of database update"

		Dim dr As DataRow = table.NewRow()
		dr("start") = e.Start
		dr("end") = e.End
		dr("id") = Guid.NewGuid().ToString()
		dr("name") = "New event"

		table.Rows.Add(dr)
		table.AcceptChanges()
'		#End Region

		DayPilotScheduler1.DataBind()
		DayPilotScheduler1.Update()
	End Sub

	Protected Sub DayPilotScheduler1_BeforeTimeHeaderRender(ByVal sender As Object, ByVal e As DayPilot.Web.Ui.Events.BeforeTimeHeaderRenderEventArgs)
	End Sub

	Protected Sub DayPilotScheduler1_BeforeCellRender(ByVal sender As Object, ByVal e As BeforeCellRenderEventArgs)
		If Not e.IsBusiness Then
			e.BackgroundColor = "#e3e3e3"
		End If
	End Sub

	Protected Sub DayPilotScheduler1_BeforeResHeaderRender(ByVal sender As Object, ByVal e As BeforeResHeaderRenderEventArgs)
		If Not DayPilotScheduler1.IsExport Then
			e.Html = String.Format("<div style='text-align:right; margin-right:5px;'>{0}</div>", e.Html)
		End If
	End Sub

	Protected Sub OnClick(ByVal sender As Object, ByVal e As EventArgs)


	End Sub

	Protected Sub ButtonExport_Click(ByVal sender As Object, ByVal e As EventArgs)

		DayPilotScheduler1.LoadStylesDefaultTheme()
		'DayPilotScheduler1.Width = Unit.Pixel(1000);  // use Unit.Percentage(100) for full width
		DayPilotScheduler1.StartDate = DayPilotScheduler1.ViewPort.Start
		DayPilotScheduler1.Days = DayPilotScheduler1.ViewPort.Days
		DayPilotScheduler1.Width = Unit.Percentage(100)

		Dim start As New Date(Date.Today.Year, Date.Today.Month, 1)
		Dim [end] As Date = start.AddMonths(1)
		Dim days As Integer = CInt(Math.Truncate(Math.Floor(([end].Subtract(start)).TotalDays)))

		DayPilotScheduler1.StartDate = start
		DayPilotScheduler1.Days = days

		DayPilotScheduler1.DataSource = Session("DaysModeMonth")
		DayPilotScheduler1.DataBind()

		Response.Clear()
		Response.ContentType = "image/png"
		Response.AddHeader("content-disposition", "attachment;filename=print.png")
		DayPilotScheduler1.DataBind()
		Dim img As MemoryStream = DayPilotScheduler1.Export(ImageFormat.Png)
		img.WriteTo(Response.OutputStream)
		Response.End()
	End Sub
End Class
